/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryRegex
implements EPPCodecComponent {
    private static final long serialVersionUID = 6061392945665281499L;
    public static final String ELM_EXPRESSION = "expression";
    public static final String ELM_EXPLANATION = "explanation";
    public static final String ATTR_LANG = "lang";
    private String rootName = null;
    private String expression = null;
    private String explanation = null;
    private String lang = null;

    public EPPRegistryRegex() {
    }

    public EPPRegistryRegex(String aExpression) {
        this();
        this.expression = aExpression;
    }

    public EPPRegistryRegex(String aExpression, String aExplanation) {
        this(aExpression);
        this.explanation = aExplanation;
    }

    public EPPRegistryRegex(String aExpression, String aExplanation, String aLang) {
        this(aExpression);
        this.explanation = aExplanation;
        this.lang = aLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPEncodeException("rootName is not set");
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPEncodeException("expression attribute is not set in EPPRegistryRegex.encode");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", "registry:" + this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.expression, "http://www.verisign.com/epp/registry-1.0", "registry:expression");
        if (this.explanation != null && this.explanation.trim().length() > 0) {
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
            Element currElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", "registry:explanation");
            Text currVal = aDocument.createTextNode(this.explanation);
            currElm.setAttribute(ATTR_LANG, this.lang);
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.rootName = aElement.getLocalName();
        this.expression = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPRESSION);
        this.explanation = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPLANATION);
        if (this.explanation != null) {
            Element theElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPLANATION);
            this.lang = theElm.getAttribute(ATTR_LANG);
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPDecodeException("expression attribute is not set in EPPRegistryRegex.decode");
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryRegex)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRegex)) {
            return false;
        }
        EPPRegistryRegex theComp = (EPPRegistryRegex)aObject;
        if (!(this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null)) {
            return false;
        }
        if (!(this.expression != null ? this.expression.equals(theComp.expression) : theComp.expression == null)) {
            return false;
        }
        if (!(this.explanation != null ? this.explanation.equals(theComp.explanation) : theComp.explanation == null)) {
            return false;
        }
        return this.explanation == null || (this.lang != null ? this.lang.equals(theComp.lang) : theComp.lang == null);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String aExpression) {
        this.expression = aExpression;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String aExplanation) {
        this.explanation = aExplanation;
    }

    String getRootName() {
        return this.rootName;
    }

    void setRootName(String aRootName) {
        int namespaceSepIndex;
        if (aRootName != null && (namespaceSepIndex = aRootName.indexOf(58)) != -1 && aRootName.length() > namespaceSepIndex) {
            aRootName = aRootName.substring(namespaceSepIndex + 1);
        }
        this.rootName = aRootName;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang;
    }
}

