/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryKey
implements EPPCodecComponent {
    private static final long serialVersionUID = 7898309423292043587L;
    public static final String ELM_NAME = "registry:keyDataInterface";
    public static final String ELM_MIN = "registry:min";
    public static final String ELM_MAX = "registry:max";
    public static final String ALGORITHM = "registry:alg";
    private Integer min = null;
    private Integer max = null;
    private List algorithms = new ArrayList();

    public EPPRegistryKey() {
    }

    public EPPRegistryKey(Integer min, Integer max, List algorithms) {
        this.min = min;
        this.max = max;
        this.algorithms = algorithms;
    }

    public EPPRegistryKey(int min, int max, List algorithms) {
        this(new Integer(min), new Integer(max), algorithms);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryKey.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.min.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MIN);
        EPPUtil.encodeString(aDocument, root, this.max.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX);
        if (this.algorithms != null && this.algorithms.size() > 0) {
            EPPUtil.encodeList(aDocument, root, this.algorithms, "http://www.verisign.com/epp/registry-1.0", ALGORITHM);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.min = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MIN);
        this.max = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX);
        this.algorithms = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ALGORITHM);
    }

    void validateState() throws EPPCodecException {
        if (this.min == null || this.min < 0) {
            throw new EPPCodecException("min is required and should be greater than or equal to 0");
        }
        if (this.max == null || this.max < this.min) {
            throw new EPPCodecException("max is required and should be greater than or equal to min");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryKey clone = (EPPRegistryKey)super.clone();
        if (this.algorithms != null) {
            clone.algorithms = (List)((ArrayList)this.algorithms).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryKey)) {
            return false;
        }
        EPPRegistryKey theComp = (EPPRegistryKey)aObject;
        if (!(this.min != null ? this.min.equals(theComp.min) : theComp.min == null)) {
            return false;
        }
        if (!(this.max != null ? this.max.equals(theComp.max) : theComp.max == null)) {
            return false;
        }
        return this.algorithms != null ? EPPUtil.equalLists(this.algorithms, theComp.algorithms) : theComp.algorithms == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public List getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List algorithms) {
        this.algorithms = algorithms;
    }

    public void addAlgorithm(String altorithm) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList();
        }
        this.algorithms.add(altorithm);
    }

    public String getRootName() {
        return ELM_NAME;
    }
}

