/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPNameWatchMapFactory
extends EPPMapFactory {
    public static final String NS = "http://www.nic.name/epp/nameWatch-1.0";
    public static final String NS_PREFIX = "nameWatch";
    public static final String NS_CONTACT = "http://www.nic.name/epp/contact-1.0";
    public static final String NS_SCHEMA = "http://www.nic.name/epp/nameWatch-1.0 nameWatch-1.0.xsd";
    public static final String ELM_NAMEWATCH_AUTHINFO = "nameWatch:authInfo";
    private EPPService service = new EPPService("nameWatch", "http://www.nic.name/epp/nameWatch-1.0", "http://www.nic.name/epp/nameWatch-1.0 nameWatch-1.0.xsd");

    public EPPNameWatchMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:info"))) {
            return new EPPNameWatchInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:create"))) {
            return new EPPNameWatchCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:delete"))) {
            return new EPPNameWatchDeleteCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:renew"))) {
            return new EPPNameWatchRenewCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:update"))) {
            return new EPPNameWatchUpdateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:transfer"))) {
            return new EPPNameWatchTransferCmd();
        }
        throw new EPPCodecException("Invalid command type " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:infData"))) {
            return new EPPNameWatchInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:creData"))) {
            return new EPPNameWatchCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:renData"))) {
            return new EPPNameWatchRenewResp();
        }
        if (name.equals(EPPUtil.getLocalName("nameWatch:trnData"))) {
            return new EPPNameWatchTransferResp();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add("nameWatch-1.0.xsd");
        return theSchemas;
    }
}

