/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryMinMax;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomainContact
extends EPPRegistryMinMax {
    private static final long serialVersionUID = 2085087247348705827L;
    public static final String ELM_NAME = "registry:contact";
    public static final String ATTR_TYPE = "type";
    public static final String TYPE_ADMIN = "admin";
    public static final String TYPE_BILLING = "billing";
    public static final String TYPE_TECH = "tech";
    private String type = null;
    public static Set VALID_TYPES = null;

    public EPPRegistryDomainContact() {
        this.rootName = ELM_NAME;
    }

    public EPPRegistryDomainContact(String type, Integer min, Integer max) {
        this();
        this.type = type;
        this.min = min;
        this.max = max;
    }

    public EPPRegistryDomainContact(String type, int min, int max) {
        this(type, new Integer(min), new Integer(max));
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (!VALID_TYPES.contains(this.type)) {
            throw new EPPEncodeException("Invalide state on EPPRegistryDomainContact.encode: type is required. Valid values: admin/billing/tech");
        }
        Element root = super.encode(aDocument);
        root.setAttribute(ATTR_TYPE, this.type);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.type = aElement.getAttribute(ATTR_TYPE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryDomainContact)super.clone();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryDomainContact)) {
            return false;
        }
        EPPRegistryDomainContact theComp = (EPPRegistryDomainContact)aObject;
        return this.type != null ? this.type.equals(theComp.type) : theComp.type == null;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    static {
        VALID_TYPES = new HashSet();
        VALID_TYPES.add(TYPE_ADMIN);
        VALID_TYPES.add(TYPE_BILLING);
        VALID_TYPES.add(TYPE_TECH);
    }
}

