/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.sql.PoolManConnection;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class PoolManConnectionHandle
implements Connection,
Serializable {
    private PoolManConnection pcon;

    public PoolManConnectionHandle(PoolManConnection poolManConnection) {
        this.pcon = poolManConnection;
    }

    void clearConnection() {
        this.pcon = null;
    }

    void assertConnectionExists() throws SQLException {
        if (this.pcon == null) {
            throw new SQLException("Either you have already closed this Connection or it has timed out, and in either case it has returned to its pool. You must re-acquire the Connection.");
        }
    }

    public void close() throws SQLException {
        this.assertConnectionExists();
        this.pcon.sendCloseEvent();
    }

    public Connection getPhysicalConnection() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getPhysicalConnection();
    }

    public Connection getNativeConnection() throws SQLException {
        this.assertConnectionExists();
        return this.getPhysicalConnection();
    }

    public PoolManConnection getPoolManConnection() throws SQLException {
        this.assertConnectionExists();
        return this.pcon;
    }

    public Statement createStatement() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.assertConnectionExists();
        this.pcon.commit();
    }

    public void rollback() throws SQLException {
        this.assertConnectionExists();
        this.pcon.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.pcon == null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.assertConnectionExists();
        this.pcon.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setTypeMap(map);
    }

    public String toString() {
        return "PoolManConnectionHandle-" + this.pcon.toString();
    }
}

