/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.management.PoolManBootstrap;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.SQLManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public class PoolMan
implements Driver {
    public static String PROTOCOL = "jdbc:poolman:";
    public static final String XML_CONFIG_FILE = "poolman.xml";
    public static final String PROPS_CONFIG_FILE = "poolman.props";
    public static final int VERSIONID = 2;
    public static final int RELEASEID = 0;
    public static boolean STARTED = false;

    /*
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block9: {
            if (null == stringArray || stringArray.length < 1) {
                System.out.println("\nUSAGE: java com.codestudio.sql.PoolMan \"[db_name]\"\nWhere the [db_name] parameter corresponds to a dbname specified in your poolman.xml file.\n");
                System.exit(1);
            }
            System.out.print("Attempting to connect to " + stringArray[0] + "... ");
            Connection connection = null;
            Class.forName("com.codestudio.sql.PoolMan").newInstance();
            connection = DriverManager.getConnection("jdbc:poolman://" + stringArray[0]);
            System.out.print("CONNECTED.\nTest passed, exiting.\n\n");
            Object var4_2 = null;
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            break block9;
            {
                catch (Exception exception) {
                    System.out.print("FAILED.\nTest Failed with the following error:\n");
                    exception.printStackTrace();
                    System.out.print("\n");
                    Object var4_3 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.exit(1);
    }

    public PoolMan() {
        this.registerDriver();
    }

    private void registerDriver() {
        boolean bl = false;
        try {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                if (!(driver instanceof PoolMan)) continue;
                bl = true;
            }
            if (!bl) {
                DriverManager.registerDriver(this);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("PoolMan Driver Failed to Load and Register with DriverManager");
        }
    }

    public static void start() throws Exception {
        if (!STARTED) {
            new PoolManBootstrap();
        }
    }

    public static DataSource getDataSource() throws SQLException {
        return PoolMan.findDataSource(null);
    }

    public static DataSource getDataSource(String string) throws SQLException {
        return PoolMan.findDataSource(string);
    }

    public static DataSource findDataSource() throws SQLException {
        return PoolMan.findDataSource(null);
    }

    public static DataSource findDataSource(String string) throws SQLException {
        SQLManager sQLManager = SQLManager.getInstance();
        JDBCPool jDBCPool = null;
        if (string == null) {
            jDBCPool = (JDBCPool)sQLManager.getPool(null);
        } else {
            try {
                jDBCPool = (JDBCPool)sQLManager.getPoolByJNDIName(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (jDBCPool == null) {
                try {
                    jDBCPool = (JDBCPool)sQLManager.getPool(string);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (jDBCPool == null) {
            throw new SQLException("No such datasource: " + string + ". Check your poolman.xml config, and be sure you " + "are using a valid dbname parameter (use dbname, not jndiName)");
        }
        return jDBCPool.getDataSource();
    }

    public static boolean nameIsValid(String string) {
        SQLManager sQLManager = SQLManager.getInstance();
        Enumeration enumeration = sQLManager.getAllPoolnames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("jdbc:poolman");
    }

    public static boolean acceptsURLString(String string) {
        return string.startsWith("jdbc:poolman");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        try {
            SQLManager sQLManager = SQLManager.getInstance();
            String string2 = null;
            if (string.indexOf("//") != -1) {
                string2 = string.substring(string.lastIndexOf("/") + 1, string.length());
            }
            if (null != properties && ((Hashtable)properties).containsKey("dbname")) {
                string2 = properties.getProperty("dbname");
            }
            if (string2 == null || string2.equals("")) {
                return sQLManager.requestConnection();
            }
            try {
                return sQLManager.requestConnection(string2);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public static Connection connect(String string) throws SQLException {
        if (!PoolMan.acceptsURLString(string)) {
            return null;
        }
        try {
            SQLManager sQLManager = SQLManager.getInstance();
            String string2 = null;
            if (string.indexOf("//") != -1) {
                string2 = string.substring(string.lastIndexOf("/") + 1, string.length());
            }
            if (string2 == null || string2.equals("")) {
                return sQLManager.requestConnection();
            }
            try {
                return sQLManager.requestConnection(string2);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return null;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

