/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.language.DeclarationType;
import de.hunsicker.jalopy.language.ModifierType;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.TableList;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class SortingSettingsPage
extends AbstractSettingsPage {
    private JCheckBox _sortCheckBox;
    private JCheckBox _sortModifiersCheckBox;
    private JTabbedPane _tabbedPane;
    private List _data;
    private List _modifiersData;
    private TableList _table;

    public SortingSettingsPage() {
        this.initialize();
    }

    SortingSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public String getPreviewFileName() {
        switch (this._tabbedPane.getSelectedIndex()) {
            case 1: {
                return "sortingmodifiers";
            }
        }
        return super.getPreviewFileName();
    }

    public void updateSettings() {
        this.settings.putBoolean(ConventionKeys.SORT, this._sortCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.SORT_MODIFIERS, this._sortModifiersCheckBox.isSelected());
        String declarationOrder = this.getSortString();
        DeclarationType.setOrder(declarationOrder);
        this.settings.put(ConventionKeys.SORT_ORDER, declarationOrder);
        String modifierOrder = this.getModifierSortString();
        ModifierType.setOrder(modifierOrder);
        this.settings.put(ConventionKeys.SORT_ORDER_MODIFIERS, modifierOrder);
    }

    private String getModifierSortString() {
        StringBuffer buf = new StringBuffer(100);
        Iterator i = this._modifiersData.iterator();
        while (i.hasNext()) {
            List rowData = (List)i.next();
            ModifierType type = (ModifierType)rowData.get(0);
            buf.append(type.getName());
            buf.append("|");
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private String getSortString() {
        StringBuffer buf = new StringBuffer(50);
        Iterator i = this._data.iterator();
        while (i.hasNext()) {
            List rowData = (List)i.next();
            DeclarationType type = (DeclarationType)rowData.get(0);
            buf.append(type.getName());
            buf.append("|");
            if (type == DeclarationType.METHOD) {
                this.settings.putBoolean(ConventionKeys.SORT_METHOD, (Boolean)rowData.get(1));
                continue;
            }
            if (type == DeclarationType.CTOR) {
                this.settings.putBoolean(ConventionKeys.SORT_CTOR, (Boolean)rowData.get(1));
                continue;
            }
            if (type == DeclarationType.CLASS) {
                this.settings.putBoolean(ConventionKeys.SORT_CLASS, (Boolean)rowData.get(1));
                continue;
            }
            if (type == DeclarationType.VARIABLE) {
                this.settings.putBoolean(ConventionKeys.SORT_VARIABLE, (Boolean)rowData.get(1));
                continue;
            }
            if (type != DeclarationType.INTERFACE) continue;
            this.settings.putBoolean(ConventionKeys.SORT_INTERFACE, (Boolean)rowData.get(1));
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private JPanel createDeclarationPane() {
        StringTokenizer tokens = new StringTokenizer(this.settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder()), "|");
        Object[][] data = new Object[7][2];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DeclarationType.valueOf(token) == DeclarationType.VARIABLE) {
                data[i][0] = DeclarationType.VARIABLE;
                data[i][1] = new Boolean(this.settings.getBoolean(ConventionKeys.SORT_VARIABLE, false));
            } else if (DeclarationType.valueOf(token) == DeclarationType.INIT) {
                data[i][0] = DeclarationType.INIT;
                data[i][1] = null;
            } else if (DeclarationType.valueOf(token) == DeclarationType.CTOR) {
                data[i][0] = DeclarationType.CTOR;
                data[i][1] = new Boolean(this.settings.getBoolean(ConventionKeys.SORT_CTOR, false));
            } else if (DeclarationType.valueOf(token) == DeclarationType.METHOD) {
                data[i][0] = DeclarationType.METHOD;
                data[i][1] = new Boolean(this.settings.getBoolean(ConventionKeys.SORT_METHOD, false));
            } else if (DeclarationType.valueOf(token) == DeclarationType.STATIC_VARIABLE_INIT) {
                data[i][0] = DeclarationType.STATIC_VARIABLE_INIT;
                data[i][1] = null;
            } else if (DeclarationType.valueOf(token) == DeclarationType.INTERFACE) {
                data[i][0] = DeclarationType.INTERFACE;
                data[i][1] = new Boolean(this.settings.getBoolean(ConventionKeys.SORT_INTERFACE, false));
            } else if (DeclarationType.valueOf(token) == DeclarationType.CLASS) {
                data[i][0] = DeclarationType.CLASS;
                data[i][1] = new Boolean(this.settings.getBoolean(ConventionKeys.SORT_CLASS, false));
            }
            ++i;
        }
        JPanel general = new JPanel();
        general.setLayout(new FlowLayout(0, 0, 0));
        general.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._sortCheckBox = new JCheckBox(this.bundle.getString("CHK_SORT_CLASS_ELEMENTS"), this.settings.getBoolean(ConventionKeys.SORT, true));
        this._sortCheckBox.addActionListener(this.trigger);
        general.add(this._sortCheckBox);
        this._sortCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SortingSettingsPage.this.refresh();
            }
        });
        JPanel typesPanel = new JPanel();
        typesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_ORDERING")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        GridBagLayout typesLayout = new GridBagLayout();
        typesPanel.setLayout(typesLayout);
        Object[] columnNames = new Object[]{this.bundle.getString("HDR_TYPE"), this.bundle.getString("HDR_SORT")};
        DataModel d = new DataModel(data, columnNames);
        this._table = new TableList(d, 2);
        this._table.addConstraint(DeclarationType.INIT, DeclarationType.VARIABLE, 1);
        this._table.addConstraint(DeclarationType.VARIABLE, DeclarationType.INIT, 2);
        this._data = d.getDataVector();
        GridBagConstraints c = new GridBagConstraints();
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        typesLayout.setConstraints(this._table, c);
        typesPanel.add(this._table);
        c.insets.top = 10;
        c.insets.bottom = 2;
        c.insets.left = 10;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        typesLayout.setConstraints(this._table.getUpButton(), c);
        typesPanel.add(this._table.getUpButton());
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        typesLayout.setConstraints(this._table.getDownButton(), c);
        typesPanel.add(this._table.getDownButton());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(general, c);
        panel.add(general);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(typesPanel, c);
        panel.add(typesPanel);
        this.refresh();
        return panel;
    }

    private JPanel createModifierPane() {
        StringTokenizer tokens = new StringTokenizer(this.settings.get(ConventionKeys.SORT_ORDER_MODIFIERS, ModifierType.getOrder()), "|");
        Object[][] data = new Object[11][1];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (ModifierType.valueOf(token) == ModifierType.PUBLIC) {
                data[i][0] = ModifierType.PUBLIC;
            } else if (ModifierType.valueOf(token) == ModifierType.PROTECTED) {
                data[i][0] = ModifierType.PROTECTED;
            } else if (ModifierType.valueOf(token) == ModifierType.PRIVATE) {
                data[i][0] = ModifierType.PRIVATE;
            } else if (ModifierType.valueOf(token) == ModifierType.STATIC) {
                data[i][0] = ModifierType.STATIC;
            } else if (ModifierType.valueOf(token) == ModifierType.FINAL) {
                data[i][0] = ModifierType.FINAL;
            } else if (ModifierType.valueOf(token) == ModifierType.ABSTRACT) {
                data[i][0] = ModifierType.ABSTRACT;
            } else if (ModifierType.valueOf(token) == ModifierType.NATIVE) {
                data[i][0] = ModifierType.NATIVE;
            } else if (ModifierType.valueOf(token) == ModifierType.TRANSIENT) {
                data[i][0] = ModifierType.TRANSIENT;
            } else if (ModifierType.valueOf(token) == ModifierType.SYNCHRONIZED) {
                data[i][0] = ModifierType.SYNCHRONIZED;
            } else if (ModifierType.valueOf(token) == ModifierType.VOLATILE) {
                data[i][0] = ModifierType.VOLATILE;
            } else if (ModifierType.valueOf(token) == ModifierType.STRICTFP) {
                data[i][0] = ModifierType.STRICTFP;
            }
            ++i;
        }
        JPanel general = new JPanel();
        general.setLayout(new FlowLayout(0, 0, 0));
        general.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._sortModifiersCheckBox = new JCheckBox(this.bundle.getString("CHK_SORT_MODIFIERS"), this.settings.getBoolean(ConventionKeys.SORT_MODIFIERS, false));
        this._sortModifiersCheckBox.addActionListener(this.trigger);
        general.add(this._sortModifiersCheckBox);
        this._sortModifiersCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SortingSettingsPage.this.refresh();
            }
        });
        JPanel typesPanel = new JPanel();
        typesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_ORDERING")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        GridBagLayout typesLayout = new GridBagLayout();
        typesPanel.setLayout(typesLayout);
        Object[] columnNames = new Object[]{this.bundle.getString("HDR_TYPE")};
        DataModel d = new DataModel(data, columnNames);
        TableList modifiersTable = new TableList(d, 2);
        JTable table = modifiersTable.getTable();
        d.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent ev) {
                SortingSettingsPage.this.trigger.actionPerformed(null);
            }
        });
        this._modifiersData = d.getDataVector();
        GridBagConstraints c = new GridBagConstraints();
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        typesLayout.setConstraints(modifiersTable, c);
        typesPanel.add(modifiersTable);
        c.insets.top = 10;
        c.insets.bottom = 2;
        c.insets.left = 10;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        JButton upButton = modifiersTable.getUpButton();
        typesLayout.setConstraints(upButton, c);
        typesPanel.add(upButton);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        JButton downButton = modifiersTable.getDownButton();
        typesLayout.setConstraints(downButton, c);
        typesPanel.add(downButton);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(general, c);
        panel.add(general);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(typesPanel, c);
        panel.add(typesPanel);
        return panel;
    }

    private void initialize() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.createDeclarationPane(), this.bundle.getString("TAB_DECLARATIONS"));
        this._tabbedPane.add((Component)this.createModifierPane(), this.bundle.getString("TAB_MODIFIERS"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabbedPane, "Center");
        if (this.getContainer() != null) {
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    String text = SortingSettingsPage.this.getContainer().loadPreview(SortingSettingsPage.this.getPreviewFileName());
                    SortingSettingsPage.this.getContainer().getPreview().setText(text);
                }
            });
        }
    }

    private void refresh() {
        if (this._sortCheckBox.isSelected()) {
            this._table.setEnabled(true);
        } else {
            this._table.setEnabled(false);
        }
    }

    private static class DataModel
    extends DefaultTableModel {
        static /* synthetic */ Class class$de$hunsicker$jalopy$language$Type;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$java$lang$String;

        public DataModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int col) {
            if (this.getValueAt(row, col) == null) {
                return false;
            }
            return col >= 1;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$de$hunsicker$jalopy$language$Type == null ? (class$de$hunsicker$jalopy$language$Type = DataModel.class$("de.hunsicker.jalopy.language.Type")) : class$de$hunsicker$jalopy$language$Type;
                }
                case 1: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = DataModel.class$("java.lang.String")) : class$java$lang$String;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

