/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.adapters.DOMAdapter;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class DOMBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: DOMBuilder.java,v $ $Revision: 1.42 $ $Date: 2002/02/12 06:15:20 $ $Name: jdom_1_0_b8 $";
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private boolean validate;
    private String adapterClass;
    private JDOMFactory factory = new DefaultJDOMFactory();

    public DOMBuilder() {
        this(false);
    }

    public DOMBuilder(String string) {
        this(string, false);
    }

    public DOMBuilder(String string, boolean bl) {
        this.adapterClass = string;
        this.setValidation(bl);
    }

    public DOMBuilder(boolean bl) {
        this.setValidation(bl);
    }

    public Document build(File file) throws JDOMException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.build(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDOMException("Error in building from " + file, fileNotFoundException);
        }
    }

    public Document build(InputStream inputStream) throws JDOMException {
        Document document = this.factory.document(null);
        org.w3c.dom.Document document2 = null;
        try {
            DOMAdapter dOMAdapter;
            if (this.adapterClass != null) {
                try {
                    dOMAdapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
                    document2 = dOMAdapter.getDocument(inputStream, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    dOMAdapter = (DOMAdapter)Class.forName("org.jdom.adapters.JAXPDOMAdapter").newInstance();
                    document2 = dOMAdapter.getDocument(inputStream, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            if (document2 == null && this.adapterClass == null) {
                try {
                    dOMAdapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
                    document2 = dOMAdapter.getDocument(inputStream, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            this.buildTree(document2, document, null, true);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    throw new JDOMException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, throwable);
                }
                throw new JDOMException("Error on line " + sAXParseException.getLineNumber(), throwable);
            }
            throw new JDOMException("Error in building from stream", throwable);
        }
        return document;
    }

    public Document build(URL uRL) throws JDOMException {
        try {
            return this.build(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new JDOMException("Error in building from " + uRL, iOException);
        }
    }

    public Document build(org.w3c.dom.Document document) {
        Document document2 = this.factory.document(null);
        this.buildTree(document, document2, null, true);
        return document2;
    }

    public Element build(org.w3c.dom.Element element) {
        Document document = this.factory.document(null);
        this.buildTree(element, document, null, true);
        return document.getRootElement();
    }

    private void buildTree(Node node, Document document, Element element, boolean bl) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                int n2 = nodeList.getLength();
                while (n < n2) {
                    this.buildTree(nodeList.item(n), document, element, true);
                    ++n;
                }
                break;
            }
            case 1: {
                Object object;
                String string;
                Object object2;
                String string2;
                Attr attr;
                String string3 = node.getNodeName();
                String string4 = "";
                String string5 = string3;
                int n = string3.indexOf(58);
                if (n >= 0) {
                    string4 = string3.substring(0, n);
                    string5 = string3.substring(n + 1);
                }
                Namespace namespace = null;
                String string6 = node.getNamespaceURI();
                namespace = string6 == null ? (element == null ? Namespace.NO_NAMESPACE : element.getNamespace(string4)) : Namespace.getNamespace(string4, string6);
                Element element2 = this.factory.element(string5, namespace);
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = namedNodeMap.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    attr = (Attr)namedNodeMap.item(n4);
                    string2 = attr.getName();
                    if (string2.startsWith("xmlns")) {
                        object2 = "";
                        n = string2.indexOf(58);
                        if (n >= 0) {
                            object2 = string2.substring(n + 1);
                        }
                        string = attr.getValue();
                        object = Namespace.getNamespace((String)object2, string);
                        if (string4.equals(object2)) {
                            element2.setNamespace((Namespace)object);
                        } else {
                            element2.addNamespaceDeclaration((Namespace)object);
                        }
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < n3) {
                    attr = (Attr)namedNodeMap.item(n4);
                    string2 = attr.getName();
                    if (!string2.startsWith("xmlns")) {
                        object2 = "";
                        string = string2;
                        n = string2.indexOf(58);
                        if (n >= 0) {
                            object2 = string2.substring(0, n);
                            string = string2.substring(n + 1);
                        }
                        object = attr.getValue();
                        Namespace namespace2 = null;
                        namespace2 = "".equals(object2) ? Namespace.NO_NAMESPACE : element2.getNamespace((String)object2);
                        Attribute attribute = this.factory.attribute(string, (String)object, namespace2);
                        element2.setAttribute(attribute);
                    }
                    ++n4;
                }
                if (bl) {
                    document.setRootElement(element2);
                } else {
                    element.addContent(element2);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n5 = nodeList.getLength();
                int n6 = 0;
                while (n6 < n5) {
                    object2 = nodeList.item(n6);
                    if (object2 != null) {
                        this.buildTree((Node)object2, document, element2, false);
                    }
                    ++n6;
                }
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                element.addContent(this.factory.text(string));
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                element.addContent(this.factory.cdata(string));
                break;
            }
            case 7: {
                if (bl) {
                    document.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                element.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (bl) {
                    document.addContent(this.factory.comment(node.getNodeValue()));
                    break;
                }
                element.addContent(this.factory.comment(node.getNodeValue()));
                break;
            }
            case 5: {
                EntityRef entityRef = this.factory.entityRef(node.getNodeName());
                element.addContent(entityRef);
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                String string = documentType.getPublicId();
                String string7 = documentType.getSystemId();
                String string8 = documentType.getInternalSubset();
                DocType docType = this.factory.docType(documentType.getName());
                docType.setPublicID(string);
                docType.setSystemID(string7);
                docType.setInternalSubset(string8);
                document.setDocType(docType);
                break;
            }
        }
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }
}

