/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.bean.struts;

import com.codestudio.bean.struts.PoolManActionFormBean;
import com.codestudio.bean.struts.PoolManMetricsBean;
import com.codestudio.bean.struts.PoolManResultsBean;
import com.codestudio.sql.PoolMan;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.SQLManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class PoolManAction
extends Action {
    public ActionForward perform(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = ((PoolManActionFormBean)actionForm).getSql();
        String string2 = ((PoolManActionFormBean)actionForm).getCurrentDatabaseName();
        HttpSession httpSession = httpServletRequest.getSession();
        PoolManResultsBean poolManResultsBean = this.getResultsBean(httpSession);
        PoolManMetricsBean poolManMetricsBean = this.getMetricsBean(httpSession);
        if (string != null && string.length() > 0) {
            try {
                this.executeSQL(string2, string, poolManResultsBean, poolManMetricsBean);
            }
            catch (Exception exception) {
                poolManResultsBean.setError(exception.toString());
            }
        }
        poolManMetricsBean.setJDBCPool((JDBCPool)SQLManager.getInstance().getPool(string2));
        httpSession.setAttribute("poolmanResults", (Object)poolManResultsBean);
        httpSession.setAttribute("poolmanMetrics", (Object)poolManMetricsBean);
        return actionMapping.findForward("poolman");
    }

    protected void executeSQL(String string, String string2, PoolManResultsBean poolManResultsBean, PoolManMetricsBean poolManMetricsBean) throws SQLException {
        poolManResultsBean.setError(null);
        poolManResultsBean.setHeaderColumns(null);
        poolManResultsBean.setRows(null);
        DataSource dataSource = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        poolManMetricsBean.incrementQueryCount();
        try {
            block21: {
                long l = System.currentTimeMillis();
                dataSource = PoolMan.findDataSource(string);
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                if (statement.execute(string2)) {
                    poolManMetricsBean.setLastQueryDuration(System.currentTimeMillis() - l);
                    resultSet = statement.getResultSet();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n = 1;
                    while (n <= resultSetMetaData.getColumnCount()) {
                        arrayList.add(resultSetMetaData.getColumnLabel(n));
                        ++n;
                    }
                    poolManResultsBean.setHeaderColumns(arrayList);
                    while (resultSet.next()) {
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        int n2 = 1;
                        while (n2 <= resultSetMetaData.getColumnCount()) {
                            Object object = null;
                            try {
                                switch (resultSetMetaData.getColumnType(n2)) {
                                    case 1: {
                                        try {
                                            object = new String(resultSet.getBytes(n2));
                                        }
                                        catch (Exception exception) {
                                            object = resultSet.getObject(n2);
                                        }
                                        break;
                                    }
                                    default: {
                                        object = resultSet.getObject(n2);
                                        break;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (object == null) {
                                object = new String("NULL");
                            }
                            arrayList2.add(object);
                            ++n2;
                        }
                        poolManResultsBean.addRow(arrayList2);
                    }
                    break block21;
                }
                poolManMetricsBean.setLastQueryDuration(System.currentTimeMillis() - l);
                String string3 = null;
                int n = statement.getUpdateCount();
                switch (n) {
                    case 0: {
                        string3 = "No rows affected";
                        break;
                    }
                    case 1: {
                        string3 = "1 row affected";
                        break;
                    }
                    default: {
                        string3 = n + " rows affected";
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                poolManResultsBean.addRow(arrayList);
            }
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            JDBCPool.closeResources(connection, statement, resultSet);
            throw throwable;
        }
        JDBCPool.closeResources(connection, statement, resultSet);
    }

    protected PoolManMetricsBean getMetricsBean(HttpSession httpSession) {
        PoolManMetricsBean poolManMetricsBean = null;
        try {
            poolManMetricsBean = (PoolManMetricsBean)httpSession.getAttribute("poolmanMetrics");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (poolManMetricsBean == null) {
            poolManMetricsBean = new PoolManMetricsBean();
        }
        return poolManMetricsBean;
    }

    protected PoolManResultsBean getResultsBean(HttpSession httpSession) {
        PoolManResultsBean poolManResultsBean = null;
        try {
            poolManResultsBean = (PoolManResultsBean)httpSession.getAttribute("poolmanResults");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (poolManResultsBean == null) {
            poolManResultsBean = new PoolManResultsBean();
        }
        return poolManResultsBean;
    }
}

