/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.Environment;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPXMLStream {
    public static final int DEFAULT_MAX_PACKET_SIZE = 355000;
    private static int maxPacketSize;
    private static DocumentBuilderFactory factory;
    EPPXMLByteArray byteArray;
    private static Logger cat;
    private static Logger packetCat;

    public EPPXMLStream() {
        this.byteArray = new EPPXMLByteArray();
    }

    public EPPXMLStream(String aParserPoolName) {
        this.byteArray = new EPPXMLByteArray(aParserPoolName);
    }

    public EPPXMLStream(String aParserPoolName, String aTransformerPoolName) {
        this.byteArray = new EPPXMLByteArray(aParserPoolName, aTransformerPoolName);
    }

    public byte[] readPacket(InputStream aStream) throws EPPException, InterruptedIOException, IOException {
        cat.debug((Object)"readPacket(): enter");
        if (aStream == null) {
            cat.error((Object)"readPacket() : null stream passed");
            throw new EPPException("EPPXMLStream.readPacket() : null stream passed");
        }
        DataInputStream theStream = new DataInputStream(aStream);
        int thePacketSize = -1;
        byte[] thePacket = null;
        try {
            thePacketSize = theStream.readInt();
            if (thePacketSize > maxPacketSize) {
                cat.error((Object)("readPacket(InputStream): Packet header specifies a packet larger that the maximum of " + maxPacketSize + " bytes"));
                throw new EPPException("EPPXMLStream.readPacket() : Packet header exceeds the maximum of " + maxPacketSize + " bytes");
            }
            cat.debug((Object)("readPacket(): Received network header with value = " + thePacketSize));
            thePacket = new byte[thePacketSize - 4];
            theStream.readFully(thePacket);
        }
        catch (EOFException ex) {
            cat.error((Object)("readPacket(InputStream): EOFException while attempting to read packet, size = " + thePacketSize + ", packet = [" + thePacket + "]: " + ex));
            throw ex;
        }
        catch (InterruptedIOException ex) {
            cat.debug((Object)("readPacket(InputStream): InterruptedIOException while attempting to read packet: " + ex));
            throw ex;
        }
        catch (IOException ex) {
            cat.error((Object)("readPacket(InputStream): IOException while attempting to read packet, size = " + thePacketSize + ", packet = [" + thePacket + "]: " + ex));
            throw ex;
        }
        cat.debug((Object)("readPacket(): Received packet [" + new String(thePacket) + "]"));
        cat.debug((Object)"readPacket(): exit");
        return thePacket;
    }

    public Document read(InputStream aStream) throws EPPAssemblerException, EPPException, IOException {
        cat.debug((Object)"read(InputStream): enter");
        if (aStream == null) {
            throw new EPPException("EPPXMLStream.read() : BAD ARGUMENT (aStream)");
        }
        Document theDoc = null;
        byte[] thePacket = this.readPacket(aStream);
        theDoc = this.byteArray.decode(thePacket);
        cat.debug((Object)"read(InputStream): exit");
        return theDoc;
    }

    public Document decodePacket(byte[] aPacket) throws EPPException, IOException {
        cat.debug((Object)"decodePacket(byte[]): enter");
        Document theDoc = this.byteArray.decode(aPacket);
        cat.debug((Object)"decodePacket(byte[]): exit");
        return theDoc;
    }

    public void write(Document aDoc, OutputStream aOutput) throws EPPException {
        cat.debug((Object)"write(Document, InputStream): enter");
        if (aOutput == null) {
            cat.error((Object)"write(Document, InputStream): aOutput == null");
            throw new EPPException("EPPXMLStream.write() : BAD ARGUMENT (aOutput)");
        }
        if (aDoc == null) {
            cat.error((Object)"write(Document, InputStream): aDoc == null");
            throw new EPPException("EPPXMLStream.write() : BAD ARGUMENT (aDoc)");
        }
        byte[] thePacket = this.byteArray.encode(aDoc);
        packetCat.debug((Object)("write() : Sending [" + new String(thePacket) + "]"));
        try {
            DataOutputStream theStream = new DataOutputStream(aOutput);
            theStream.writeInt(thePacket.length + 4);
            aOutput.write(thePacket);
            aOutput.flush();
        }
        catch (IOException ex) {
            cat.error((Object)("write(Document, InputStream) : Writing to stream :" + ex));
            throw new EPPException("EPPXMLStream.write() : Writing to stream " + ex);
        }
        cat.debug((Object)"write(Document, InputStream): exit");
    }

    static {
        factory = null;
        cat = Logger.getLogger((String)EPPXMLStream.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
        packetCat = Logger.getLogger((String)(EPPXMLStream.class.getName() + ".packet"), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        maxPacketSize = 355000;
        String maxPacketSizeProp = Environment.getOption("EPP.MaxPacketSize");
        if (maxPacketSizeProp != null) {
            try {
                maxPacketSize = Integer.parseInt(maxPacketSizeProp);
            }
            catch (NumberFormatException ex) {
                System.err.println("EPPXMLStream: EPP.MaxPacketSize property format error: " + ex);
            }
        }
        cat.info((Object)("maxPacketSize = " + maxPacketSize));
    }
}

