/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.registry.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.EPPRegistryContact;
import com.verisign.epp.codec.registry.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.EPPRegistryContactName;
import com.verisign.epp.codec.registry.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.EPPRegistryDS;
import com.verisign.epp.codec.registry.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.EPPRegistryDomain;
import com.verisign.epp.codec.registry.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.EPPRegistryFields;
import com.verisign.epp.codec.registry.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.EPPRegistryHost;
import com.verisign.epp.codec.registry.EPPRegistryIDN;
import com.verisign.epp.codec.registry.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.EPPRegistryKeyValue;
import com.verisign.epp.codec.registry.EPPRegistryLanguageType;
import com.verisign.epp.codec.registry.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPhase;
import com.verisign.epp.codec.registry.EPPRegistryPostal;
import com.verisign.epp.codec.registry.EPPRegistryRGP;
import com.verisign.epp.codec.registry.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistryRelated;
import com.verisign.epp.codec.registry.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.EPPRegistrySLA;
import com.verisign.epp.codec.registry.EPPRegistrySLAInfo;
import com.verisign.epp.codec.registry.EPPRegistryServices;
import com.verisign.epp.codec.registry.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.EPPRegistryZone;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import com.verisign.epp.codec.registry.EPPRegistryZoneList;
import com.verisign.epp.codec.registry.EPPRegistryZoneMember;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPRegistryHandler;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnvSingle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class RegistryHandler
extends EPPRegistryHandler {
    private static final String svrTransId = "54322-XYZ";
    private static List availableTlds = new ArrayList();
    private static Logger cat;

    protected EPPEventResponse doRegistryCreate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doRegistryCreate: enter");
        EPPRegistryCreateCmd message = (EPPRegistryCreateCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        String name = message.getZone().getName();
        boolean tldExist = false;
        EPPRegistryCreateResp theResponse = new EPPRegistryCreateResp(respTransId, name);
        Iterator phaseIterator = null;
        for (EPPRegistryZoneInfo zoneInfo : availableTlds) {
            if (!zoneInfo.getName().equals(name)) continue;
            tldExist = true;
            theResponse.setResult(2302, "TLD name exists");
            phaseIterator = zoneInfo.getPhases().iterator();
            break;
        }
        if (!tldExist) {
            EPPRegistryZoneInfo zoneInfo = new EPPRegistryZoneInfo();
            zoneInfo.setName(message.getZone().getName());
            zoneInfo.setPhases(message.getZone().getPhases());
            zoneInfo.setServices(message.getZone().getServices());
            zoneInfo.setDomain(message.getZone().getDomain());
            zoneInfo.setHost(message.getZone().getHost());
            zoneInfo.setContact(message.getZone().getContact());
            zoneInfo.setCreatedDate(new Date());
            zoneInfo.setLastUpdatedBy(null);
            zoneInfo.setLastUpdatedDate(null);
            availableTlds.add(zoneInfo);
            phaseIterator = message.getZone().getPhases().iterator();
        }
        while (phaseIterator.hasNext()) {
            EPPRegistryPhase phase = (EPPRegistryPhase)phaseIterator.next();
            if ("sunrise".equals(phase.getType())) {
                theResponse.setCreateDate(phase.getStartDate());
            }
            if ("open".equals(phase.getType()) && phase.getEndDate() == null) continue;
        }
        cat.debug((Object)"doRegistryCreate: exit");
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doRegistryUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doRegistryUpdate: enter");
        EPPRegistryUpdateCmd message = (EPPRegistryUpdateCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        String name = message.getZone().getName();
        boolean tldExist = false;
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPRegistryZoneInfo zoneInfo = null;
        Iterator it = availableTlds.iterator();
        while (it.hasNext()) {
            zoneInfo = (EPPRegistryZoneInfo)it.next();
            if (!zoneInfo.getName().equals(name)) continue;
            tldExist = true;
            it.remove();
            break;
        }
        if (tldExist) {
            EPPRegistryZoneInfo oldTld = zoneInfo;
            zoneInfo = new EPPRegistryZoneInfo();
            zoneInfo.setName(message.getZone().getName());
            zoneInfo.setPhases(message.getZone().getPhases());
            zoneInfo.setServices(message.getZone().getServices());
            zoneInfo.setDomain(message.getZone().getDomain());
            zoneInfo.setHost(message.getZone().getHost());
            zoneInfo.setContact(message.getZone().getContact());
            zoneInfo.setCreatedDate(oldTld.getCreatedDate());
            zoneInfo.setLastUpdatedDate(new Date());
            zoneInfo.setCreatedBy(oldTld.getCreatedBy());
            availableTlds.add(zoneInfo);
            theResponse.setResult(1000);
        } else {
            theResponse.setResult(2303, "Tld " + message.getZone().getName() + " does not exist. Please create it first");
        }
        cat.debug((Object)"doRegistryUpdate: exit");
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doRegistryCheck(EPPEvent aEvent, Object aData) {
        EPPRegistryCheckCmd message = (EPPRegistryCheckCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        List names = message.getNames();
        ArrayList<EPPRegistryCheckResult> results = new ArrayList<EPPRegistryCheckResult>();
        block0: for (String name : names) {
            EPPRegistryCheckResult result = null;
            for (EPPRegistryZoneInfo zoneInfo : availableTlds) {
                if (!zoneInfo.getName().equals(name)) continue;
                result = new EPPRegistryCheckResult(name, Boolean.FALSE);
                result.setReason("Already taken");
                results.add(result);
                continue block0;
            }
            result = new EPPRegistryCheckResult(name, Boolean.TRUE);
            result.setReason("Available");
            results.add(result);
        }
        EPPRegistryCheckResp theResponse = results.size() == 1 ? new EPPRegistryCheckResp(respTransId, (EPPRegistryCheckResult)results.get(0)) : new EPPRegistryCheckResp(respTransId, results);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doRegistryInfo(EPPEvent aEvent, Object aData) {
        EPPResponse theResponse;
        cat.debug((Object)"doRegistryInfo ...");
        EPPRegistryInfoCmd message = (EPPRegistryInfoCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        boolean all = message.isAll();
        if (all) {
            EPPRegistryZoneList zoneList = new EPPRegistryZoneList();
            for (EPPRegistryZoneInfo info : availableTlds) {
                EPPRegistryZone zone = new EPPRegistryZone(info.getName(), info.getCreatedDate(), info.getLastUpdatedDate());
                zoneList.addZone(zone);
            }
            theResponse = new EPPRegistryInfoResp(respTransId, zoneList);
        } else {
            EPPRegistryZoneInfo zoneInfo = null;
            for (EPPRegistryZoneInfo ti : availableTlds) {
                if (!ti.getName().equalsIgnoreCase(message.getName())) continue;
                zoneInfo = ti;
                zoneInfo.setGroup("1");
                if (zoneInfo.getName().length() == 0) {
                    zoneInfo.setSubProduct("dot");
                    break;
                }
                if (zoneInfo.getName().length() == 1) {
                    zoneInfo.setSubProduct("dot" + zoneInfo.getName().substring(0, 1).toUpperCase());
                    break;
                }
                zoneInfo.setSubProduct("dot" + zoneInfo.getName().substring(0, 1).toUpperCase() + zoneInfo.getName().substring(1));
                break;
            }
            if (zoneInfo != null) {
                if ("com".equalsIgnoreCase(zoneInfo.getName()) && zoneInfo.getRelated() == null) {
                    EPPRegistryRelated related = new EPPRegistryRelated();
                    EPPRegistryFields fields = new EPPRegistryFields();
                    fields.setType("sync");
                    fields.addField("clID");
                    fields.addField("registrant");
                    fields.addField("ns");
                    related.setFields(fields);
                    related.addMember(new EPPRegistryZoneMember("com", "equal"));
                    related.addMember(new EPPRegistryZoneMember("com2", "equal"));
                    related.addMember(new EPPRegistryZoneMember("com3", "equal"));
                    zoneInfo.setRelated(related);
                }
                theResponse = new EPPRegistryInfoResp(respTransId, zoneInfo);
                theResponse.setResult(1000);
            } else {
                cat.warn((Object)("tld does not exist: " + message.getName()));
                theResponse = new EPPResponse();
                theResponse.setResult(2303);
            }
        }
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doRegistryDelete(EPPEvent aEvent, Object aData) {
        EPPRegistryDeleteCmd theMessage = (EPPRegistryDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        String name = theMessage.getName();
        boolean deleted = false;
        Iterator it = availableTlds.iterator();
        while (it.hasNext()) {
            EPPRegistryZoneInfo zoneInfo = (EPPRegistryZoneInfo)it.next();
            if (!zoneInfo.getName().equals(name)) continue;
            it.remove();
            theResponse.setResult(1000);
            deleted = true;
            break;
        }
        if (!deleted) {
            theResponse.setResult(2303, "Requested tld \"" + name + "\" does not exist");
        }
        return new EPPEventResponse(theResponse);
    }

    private static EPPRegistryDomain buildInfoDomain(int seq) {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(new Integer(2));
        domainName.setMinLength(new Integer(5));
        domainName.setMaxLength(new Integer(50));
        domainName.setAlphaNumStart(new Boolean(true));
        domainName.setAlphaNumEnd(new Boolean(false));
        domainName.setOnlyDnsChars(new Boolean(true));
        ArrayList<EPPRegistryRegex> regex = new ArrayList<EPPRegistryRegex>();
        EPPRegistryRegex r = new EPPRegistryRegex("^\\w+.*$", "test regex");
        regex.add(r);
        r = new EPPRegistryRegex("^\\d+.*$");
        regex.add(r);
        domainName.setRegex(regex);
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved" + seq + "1");
        rNames.add("reserved" + seq + "2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(new Integer(3));
            domainName.getReservedNames().setReservedNames(new ArrayList());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguageType("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", "restricted"));
        idn.addLanguage(new EPPRegistryLanguageType("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", "blocked"));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(new Boolean(true));
        domain.setContactsSupported(new Boolean(true));
        domain.addContact(new EPPRegistryDomainContact("admin", 1, 4));
        domain.addContact(new EPPRegistryDomainContact("billing", 2, 5));
        domain.addContact(new EPPRegistryDomainContact("tech", 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        domain.setChildHostLimit(new EPPRegistryDomainHostLimit(2, 32));
        domain.addPeriod(new EPPRegistryDomainPeriod("create", 1, "y", 10, "y", 2, "y"));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, "y", 10, "y", 2, "y"));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, "y", 8, "y", 2, "y"));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(1, "y"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, "d"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, "m"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, "h"));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, "m"));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, "m"));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, "m"));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        EPPRegistryDS ds = new EPPRegistryDS(1, 3, null, null);
        ds.addAlgorithm("algDS" + seq + "1");
        ds.addAlgorithm("algDS" + seq + "2");
        ds.addDigestType("digest" + seq + "1");
        ds.addDigestType("digest" + seq + "2");
        dnssec.setDs(ds);
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(new Integer(12));
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("dk" + seq + "1", "dv" + seq + "1"));
        customData.addKeyValue(new EPPRegistryKeyValue("dk" + seq + "2", "dv" + seq + "2"));
        domain.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        return domain;
    }

    private static EPPRegistryHost buildInfoHost(int seq) {
        EPPRegistryHost host = new EPPRegistryHost();
        host.setInternal(new EPPRegistryInternalHost(5, 15, "perZone"));
        host.setExternal(new EPPRegistryExternalHost(2, 12, "perZone"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp" + seq + "1"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp" + seq + "2"));
        host.setMaxCheckHost(new Integer(15));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("hk" + seq + "1", "hv" + seq + "1"));
        customData.addKeyValue(new EPPRegistryKeyValue("hk" + seq + "2", "hv" + seq + "2"));
        host.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        host.setSupportedStatus(supportedStatus);
        return host;
    }

    private static EPPRegistryContact buildContact(int seq) {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setSharePolicy("perZone");
        contact.setLocSupport(Boolean.TRUE);
        contact.setIntSupport(Boolean.FALSE);
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("ck" + seq + "1", "cv1" + seq + ""));
        customData.addKeyValue(new EPPRegistryKeyValue("ck" + seq + "2", "cv" + seq + "2"));
        contact.setCustomData(customData);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(new Integer(15));
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setName(new EPPRegistryContactName(6, 16));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        ArrayList<EPPRegistryRegex> emailRegex = new ArrayList<EPPRegistryRegex>();
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp"));
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp in ch", "ch"));
        postalInfo.setEmailRegex(emailRegex);
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        contact.setMaxCheckContact(new Integer(5));
        contact.setPostalInfo(postalInfo);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        return contact;
    }

    static {
        int len = 10;
        String num = EPPEnvSingle.getProperty("Ini.Zone.Count", "10");
        if (num != null) {
            len = Integer.parseInt(num);
        }
        for (int i = 0; i < len; ++i) {
            EPPRegistryZoneInfo zoneInfo = new EPPRegistryZoneInfo("samplezone" + i, "client" + i, new Date());
            zoneInfo.setLastUpdatedBy("client" + i);
            zoneInfo.setLastUpdatedDate(new Date());
            zoneInfo.setGroup("g" + i);
            zoneInfo.setSubProduct("dotSamplezone" + i);
            EPPRegistryRelated related = new EPPRegistryRelated();
            EPPRegistryFields fields = new EPPRegistryFields();
            fields.setType("sync");
            fields.addField("clID");
            fields.addField("registrant");
            fields.addField("ns");
            related.setFields(fields);
            related.addMember(new EPPRegistryZoneMember("EXAMPLE", "equal"));
            related.addMember(new EPPRegistryZoneMember("EXAMPLE2", "equal"));
            related.addMember(new EPPRegistryZoneMember("EXAMPLE3", "equal"));
            zoneInfo.setRelated(related);
            EPPRegistryPhase phase = new EPPRegistryPhase("sunrise", new Date(), new Date());
            phase.setMode("pending-application");
            zoneInfo.addPhase(phase);
            phase = new EPPRegistryPhase("pre-delegation", new Date(), new Date());
            phase.setMode("pending-registration");
            zoneInfo.addPhase(phase);
            zoneInfo.addPhase(new EPPRegistryPhase("landrush", new Date(), new Date()));
            zoneInfo.addPhase(new EPPRegistryPhase("pre-delegation", new Date(), new Date()));
            zoneInfo.addPhase(new EPPRegistryPhase("claims", new Date(), new Date()));
            zoneInfo.addPhase(new EPPRegistryPhase("open", new Date()));
            zoneInfo.addPhase(new EPPRegistryPhase("custom", "userDefined", new Date()));
            EPPRegistryServices services = new EPPRegistryServices();
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/rgp-poll-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:host-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:contact-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:domain-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/lowbalance-poll-1.0", Boolean.FALSE));
            EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
            services.setExtension(svcExt);
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign-grs.com/epp/namestoreExt-1.1", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:rgp-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/sync-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/idnLang-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/jobsContact-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/premiumdomain-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:secDNS-1.1", Boolean.FALSE));
            zoneInfo.setServices(services);
            EPPRegistrySLAInfo slaInfo = new EPPRegistrySLAInfo();
            slaInfo.addSla(new EPPRegistrySLA("response", "ext", "create", 500.0, "ms"));
            slaInfo.addSla(new EPPRegistrySLA("availability", null, "create", 99.9, "percent"));
            zoneInfo.setSlaInfo(slaInfo);
            zoneInfo.setCreatedBy("crId");
            zoneInfo.setCreatedDate(new Date());
            zoneInfo.setLastUpdatedBy("upId");
            zoneInfo.setLastUpdatedDate(new Date());
            zoneInfo.setDomain(RegistryHandler.buildInfoDomain(i));
            zoneInfo.setHost(RegistryHandler.buildInfoHost(i));
            zoneInfo.setContact(RegistryHandler.buildContact(i));
            availableTlds.add(zoneInfo);
        }
        cat = Logger.getLogger((String)RegistryHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

