/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheck;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResp;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResult;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainReAssignCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.DomainHandler;
import java.math.BigDecimal;
import java.util.Vector;

public class PremiumDomainHandler
extends DomainHandler {
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theMessage = (EPPDomainCheckCmd)aEvent.getMessage();
        EPPPremiumDomainCheckResult eppPremiumDomainCheckResult = null;
        Vector<EPPPremiumDomainCheckResult> premiumResults = new Vector<EPPPremiumDomainCheckResult>();
        EPPEventResponse theEventResponse = super.doDomainCheck(aEvent, aData);
        EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
        EPPPremiumDomainCheck theExt = (EPPPremiumDomainCheck)theMessage.getExtension(EPPPremiumDomainCheck.class);
        if (theResponse.isSuccess() && theExt != null && theExt.getFlag().booleanValue()) {
            EPPDomainCheckResp thecheckResponse = (EPPDomainCheckResp)theResponse;
            for (int i = 0; i < thecheckResponse.getCheckResults().size(); ++i) {
                EPPDomainCheckResult currResult = (EPPDomainCheckResult)thecheckResponse.getCheckResults().elementAt(i);
                if (currResult.getName().equals("non-premiumdomain.tv")) {
                    eppPremiumDomainCheckResult = new EPPPremiumDomainCheckResult(currResult.getName(), false);
                } else {
                    eppPremiumDomainCheckResult = new EPPPremiumDomainCheckResult(currResult.getName(), true);
                    if (currResult.isAvailable()) {
                        eppPremiumDomainCheckResult.setPrice(new BigDecimal("125.00"));
                        eppPremiumDomainCheckResult.setRenewalPrice(new BigDecimal("75.00"));
                    }
                }
                premiumResults.addElement(eppPremiumDomainCheckResult);
            }
            if (premiumResults.size() > 0) {
                theResponse.addExtension(new EPPPremiumDomainCheckResp(premiumResults));
            }
        }
        return theEventResponse;
    }

    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), "54322-XYZ");
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        if (!theMessage.hasExtension(EPPPremiumDomainReAssignCmd.class)) {
            System.out.println("Premium Domain ReAssign command is missing");
            theResponse.setResult(2003);
            return new EPPEventResponse(theResponse);
        }
        EPPPremiumDomainReAssignCmd theExt = (EPPPremiumDomainReAssignCmd)theMessage.getExtension(EPPPremiumDomainReAssignCmd.class);
        if (theExt.getShortName() == null || theExt.getShortName().trim().equals("")) {
            theResponse.setResult(2003);
            return new EPPEventResponse(theResponse);
        }
        return new EPPEventResponse(theResponse);
    }
}

