/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPGenHandler;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class GenHandler
extends EPPGenHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = Logger.getLogger((String)GenHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    protected EPPEventResponse doLogin(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"<<< Received Login >>>");
        SessionData sessionData = (SessionData)aData;
        EPPLoginCmd theMessage = (EPPLoginCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (sessionData.isLoggedIn()) {
            cat.error((Object)"Cleint already has a session established.");
            cat.error((Object)"Sending COMMAND USE ERROR for response...");
            EPPResult result = new EPPResult(2002);
            result.addExtValueReason("login command received within the bounds of an existing session");
            return new EPPEventResponse(new EPPResponse(transId, result));
        }
        EPPResponse theResponse = new EPPResponse(transId);
        cat.debug((Object)"User has logged in. Setting session data login flag to true");
        sessionData.setLoggedIn(true);
        sessionData.setLoginCmd(theMessage);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doLogout(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"<<< Received Logout Command >>>");
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        EPPEventResponse returnEventResponse = null;
        if (sessionData.isLoggedIn()) {
            cat.debug((Object)"User is invoked in logout while logged in - Good. Logging them out");
            theResponse.setResult(1500);
        } else {
            cat.debug((Object)"User is invoked in logout while NOT logged in!!!!.Sending COMMAND FAILED error...");
            theResponse.setResult(2500);
        }
        returnEventResponse = new EPPEventResponse(theResponse);
        sessionData.setLogoutOccured(true);
        return returnEventResponse;
    }

    protected EPPEventResponse doPoll(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPPollCmd theMessage = (EPPPollCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = null;
        EPPPollQueueMgr theMgr = EPPPollQueueMgr.getInstance();
        if (theMessage.getOp().equals("req")) {
            cat.debug((Object)"doPoll: Poll request received");
            try {
                theResponse = theMgr.get(null, null);
                cat.debug((Object)("doPoll: Got poll message [" + theResponse + "]"));
            }
            catch (EPPPollQueueException ex) {
                EPPResult theResult;
                if (ex.getType() == 1) {
                    cat.debug((Object)"doPoll: Queue is empty");
                    theResult = new EPPResult(1300);
                } else {
                    cat.error((Object)("doPoll: Unexpected queue exception: " + ex));
                    theResult = new EPPResult(2400);
                }
                theResponse = new EPPResponse(transId, theResult);
            }
        } else if (theMessage.getOp().equals("ack")) {
            String msgId = theMessage.getMsgID();
            cat.debug((Object)("doPoll: Poll ack received for message " + msgId));
            if (msgId.equals("CLOSE-SESSION-TEST")) {
                sessionData.setLogoutOccured(true);
                return null;
            }
            try {
                theResponse = theMgr.delete(null, msgId, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doPoll: Error deleting message " + msgId));
                EPPResult theResult = new EPPResult(2303);
                theResult.addExtValue(new EPPExtValue("Message could not be found", "<epp:poll msgID=\"" + msgId + "\" op=\"ack\"/>"));
                theResponse = new EPPResponse(transId, theResult);
            }
        } else {
            cat.error((Object)("doPoll: Invalid operation " + theMessage.getOp()));
            EPPResult theResult = new EPPResult(2001);
            theResult.addExtValueReason("op=" + theMessage.getOp());
            theResponse = new EPPResponse(transId, theResult);
        }
        theResponse.setTransId(transId);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doHello(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPGreeting greeting = sessionData.getGreeting();
        return new EPPEventResponse(greeting);
    }
}

