/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoCmd;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoResp;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

public class EPPWhoWas {
    private Vector extensions = null;
    private EPPResponse response = null;
    private EPPSession session = null;
    private String type = "domain";
    private String name = null;
    private String roid = null;
    private String transId = null;

    public EPPWhoWas(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public EPPResponse getResponse() {
        return this.response;
    }

    public EPPSession getSession() {
        return this.session;
    }

    public EPPWhoWasInfoResp sendInfo() throws EPPCommandException {
        EPPWhoWasInfoCmd theCmd = new EPPWhoWasInfoCmd(this.transId, this.type);
        theCmd.setName(this.name);
        theCmd.setRoid(this.roid);
        theCmd.setExtensions(this.extensions);
        this.response = this.session.processDocument(theCmd);
        if (!(this.response instanceof EPPWhoWasInfoResp)) {
            throw new EPPCommandException("Unexpected response type of " + this.response.getClass().getName() + ", expecting " + EPPWhoWasInfoResp.class.getName());
        }
        this.resetWhoWas();
        return (EPPWhoWasInfoResp)this.response;
    }

    private void resetWhoWas() {
        this.type = "domain";
        this.name = null;
        this.roid = null;
        this.extensions = null;
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public void setSession(EPPSession aSession) {
        this.session = aSession;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }
}

