/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryContact;
import com.verisign.epp.codec.registry.EPPRegistryDomain;
import com.verisign.epp.codec.registry.EPPRegistryHost;
import com.verisign.epp.codec.registry.EPPRegistryPhase;
import com.verisign.epp.codec.registry.EPPRegistryRelated;
import com.verisign.epp.codec.registry.EPPRegistrySLAInfo;
import com.verisign.epp.codec.registry.EPPRegistryServices;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryZoneInfo
implements EPPCodecComponent {
    private static final long serialVersionUID = 8689168181168142683L;
    static final String ELM_NAME = "registry:zone";
    private static final String ELM_REGISTRY_NAME = "registry:name";
    private static final String ELM_GROUP = "registry:group";
    private static final String ELM_SUB_PRODUCT = "registry:subProduct";
    private static final String ELM_CRDATE = "registry:crDate";
    private static final String ELM_CRID = "registry:crID";
    private static final String ELM_UPDATE = "registry:upDate";
    private static final String ELM_UPID = "registry:upID";
    private static Logger cat = Logger.getLogger((String)EPPRegistryZoneInfo.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String name = null;
    private String group = null;
    private String subProduct = null;
    private EPPRegistryRelated related = null;
    private List phases = new ArrayList();
    private EPPRegistryServices services = null;
    private EPPRegistrySLAInfo slaInfo = null;
    private String createdBy = null;
    private Date createdDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private EPPRegistryDomain domain = null;
    private EPPRegistryHost host = null;
    private EPPRegistryContact contact = null;

    public EPPRegistryZoneInfo() {
    }

    public EPPRegistryZoneInfo(String name) {
        this();
        this.name = name;
    }

    public EPPRegistryZoneInfo(String name, String aCreatedBy, Date aCreatedDate) {
        this(name);
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRegistryInfoResp.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on EPPRegistryInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        if (this.group != null && this.group.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.group, "http://www.verisign.com/epp/registry-1.0", ELM_GROUP);
        }
        if (this.subProduct != null && this.subProduct.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.subProduct, "http://www.verisign.com/epp/registry-1.0", ELM_SUB_PRODUCT);
        }
        if (this.related != null) {
            EPPUtil.encodeComp(aDocument, root, this.related);
        }
        if (this.phases != null && this.phases.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.phases);
        }
        if (this.services != null) {
            EPPUtil.encodeComp(aDocument, root, this.services);
        }
        if (this.slaInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.slaInfo);
        }
        if (this.createdBy != null && this.createdBy.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.createdBy, "http://www.verisign.com/epp/registry-1.0", ELM_CRID);
        }
        if (this.createdDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "http://www.verisign.com/epp/registry-1.0", ELM_CRDATE);
        }
        if (this.lastUpdatedBy != null && this.lastUpdatedBy.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "http://www.verisign.com/epp/registry-1.0", ELM_UPID);
        }
        if (this.lastUpdatedDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE);
        }
        EPPUtil.encodeComp(aDocument, root, this.domain);
        EPPUtil.encodeComp(aDocument, root, this.host);
        EPPUtil.encodeComp(aDocument, root, this.contact);
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        this.group = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_GROUP);
        this.subProduct = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_SUB_PRODUCT);
        this.related = (EPPRegistryRelated)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:related", EPPRegistryRelated.class);
        this.phases = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:phase", EPPRegistryPhase.class);
        this.services = (EPPRegistryServices)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:services", EPPRegistryServices.class);
        this.slaInfo = (EPPRegistrySLAInfo)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:slaInfo", EPPRegistrySLAInfo.class);
        this.createdBy = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CRID);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CRDATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_UPID);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE);
        this.domain = (EPPRegistryDomain)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:domain", EPPRegistryDomain.class);
        this.host = (EPPRegistryHost)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:host", EPPRegistryHost.class);
        this.contact = (EPPRegistryContact)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:contact", EPPRegistryContact.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZoneInfo)) {
            return false;
        }
        EPPRegistryZoneInfo theComp = (EPPRegistryZoneInfo)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.group, theComp.group)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): group not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.subProduct, theComp.subProduct)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): subProduct not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.domain, theComp.domain)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): domain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.host, theComp.host)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): host not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contact, theComp.contact)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): contact not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdBy, theComp.createdBy)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): createdBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, theComp.createdDate)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.related, theComp.related)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): family not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedBy, theComp.lastUpdatedBy)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): lastUpdatedBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, theComp.lastUpdatedDate)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): lastUpdatedDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.phases, theComp.phases)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): phases not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.services, theComp.services)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): services not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.slaInfo, theComp.slaInfo)) {
            cat.error((Object)"EPPRegistryZoneInfo.equals(): slaInfo not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required element is not set");
        }
        if (this.domain == null) {
            throw new EPPCodecException("domain required element is not set");
        }
        if (this.host == null) {
            throw new EPPCodecException("host required element is not set");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZoneInfo clone = (EPPRegistryZoneInfo)super.clone();
        if (this.related != null) {
            clone.related = (EPPRegistryRelated)this.related.clone();
        }
        if (this.phases != null) {
            clone.phases = (List)((ArrayList)this.phases).clone();
        }
        if (this.services != null) {
            clone.services = (EPPRegistryServices)this.services.clone();
        }
        if (this.slaInfo != null) {
            clone.slaInfo = (EPPRegistrySLAInfo)this.slaInfo.clone();
        }
        if (this.domain != null) {
            clone.domain = (EPPRegistryDomain)this.domain.clone();
        }
        if (this.host != null) {
            clone.host = (EPPRegistryHost)this.host.clone();
        }
        if (this.contact != null) {
            clone.contact = (EPPRegistryContact)this.contact.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EPPRegistryRelated getRelated() {
        return this.related;
    }

    public boolean hasRelated() {
        return this.related != null;
    }

    public void setRelated(EPPRegistryRelated aRelated) {
        this.related = aRelated;
    }

    public List getPhases() {
        return this.phases;
    }

    public void setPhases(List phases) {
        this.phases = phases;
    }

    public void addPhase(EPPRegistryPhase phase) {
        if (this.phases == null) {
            this.phases = new ArrayList();
        }
        this.phases.add(phase);
    }

    public EPPRegistryServices getServices() {
        return this.services;
    }

    public void setServices(EPPRegistryServices services) {
        this.services = services;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public EPPRegistryDomain getDomain() {
        return this.domain;
    }

    public void setDomain(EPPRegistryDomain domain) {
        this.domain = domain;
    }

    public EPPRegistryHost getHost() {
        return this.host;
    }

    public void setHost(EPPRegistryHost host) {
        this.host = host;
    }

    public EPPRegistryContact getContact() {
        return this.contact;
    }

    public void setContact(EPPRegistryContact contact) {
        this.contact = contact;
    }

    public EPPRegistrySLAInfo getSlaInfo() {
        return this.slaInfo;
    }

    public void setSlaInfo(EPPRegistrySLAInfo slaInfo) {
        this.slaInfo = slaInfo;
    }

    public String getSubProduct() {
        return this.subProduct;
    }

    public void setSubProduct(String subProduct) {
        this.subProduct = subProduct;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

