/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainCheck();
            this.domainInfo();
            this.domainCreate();
            this.domainDelete();
            this.domainRenew();
            this.domainUpdate();
            this.domainTransferQuery();
            this.domainTransfer();
            this.domainPoll();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void domainCheck() {
        EPPDomainCheckResult currResult;
        EPPDomainCheckResp response;
        this.printStart("domainCheck");
        try {
            int i;
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCheck: Check single domain name (example.com)");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            response = this.domain.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\ndomainCheck: Response = [" + response + "]");
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                currResult = (EPPDomainCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("domainCheck: Domain " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("domainCheck: Domain " + currResult.getName() + " is not available");
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            int i;
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCheck: Check multiple domain names (example1.com, example2.com, example3.com)");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("example1.com");
            this.domain.addDomainName("example2.com");
            this.domain.addDomainName("example3.com");
            for (i = 0; i <= 10; ++i) {
                this.domain.addDomainName(this.makeDomainName());
            }
            response = this.domain.sendCheck();
            System.out.println("\ndomainCheck: Response = [" + response + "]");
            System.out.println("Client Transaction Id = " + response.getTransId().getClientTransId());
            System.out.println("Server Transaction Id = " + response.getTransId().getServerTransId());
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                currResult = (EPPDomainCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("domainCheck: Domain " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("domainCheck: Domain " + currResult.getName() + " is not available");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void domainInfo() {
        EPPDomainInfoResp response;
        this.printStart("domainInfo");
        try {
            int i;
            System.out.println("\ndomainInfo: Domain info for subordinate hosts");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setHosts("sub");
            response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            System.out.println("domainInfo: name            = " + response.getName());
            System.out.println("domainInfo: client id       = " + response.getClientId());
            System.out.println("domainInfo: roid            = " + response.getRoid());
            System.out.println("domainInfo: created by      = " + response.getCreatedBy());
            System.out.println("domainInfo: create date     = " + response.getCreatedDate());
            System.out.println("domainInfo: expiration date = " + response.getExpirationDate());
            System.out.println("domainInfo: Registrant      = " + response.getRegistrant());
            if (response.getContacts() != null) {
                for (i = 0; i < response.getContacts().size(); ++i) {
                    EPPDomainContact myContact = (EPPDomainContact)response.getContacts().elementAt(i);
                    System.out.println("Contact Name : " + myContact.getName());
                    System.out.println("Contact Type : " + myContact.getType());
                }
            }
            if (response.getAuthInfo() != null) {
                System.out.println("Authorization        : " + response.getAuthInfo().getPassword());
                System.out.println("Authorization (Roid) : " + response.getAuthInfo().getRoid());
            }
            if (response.getHosts() != null) {
                for (i = 0; i < response.getHosts().size(); ++i) {
                    System.out.println("Host Name : " + response.getHosts().elementAt(i));
                }
            }
            if (response.getNses() != null) {
                for (i = 0; i < response.getNses().size(); ++i) {
                    System.out.println("Name Server : " + response.getNses().elementAt(i));
                }
            }
            if (response.getStatuses() != null) {
                for (i = 0; i < response.getStatuses().size(); ++i) {
                    EPPDomainStatus myStatus = (EPPDomainStatus)response.getStatuses().elementAt(i);
                    System.out.println("Lang     : " + myStatus.getLang());
                    System.out.println("Status   : " + myStatus.getStatus());
                }
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\ndomainInfo: Domain info with authorization string");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("2fooBAR");
            response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            System.out.println("domainInfo: name = " + response.getName());
            System.out.println("domainInfo: client id = " + response.getClientId());
            System.out.println("domainInfo: roid            = " + response.getRoid());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    public void domainCreate() {
        EPPDomainCreateResp response;
        String theDomainName;
        this.printStart("domainCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            theDomainName = this.makeDomainName();
            System.out.println("domainCreate: Create " + theDomainName + " with period of 0");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString("ClientX");
            response = this.domain.sendCreate();
            System.out.println("domainCreate with period of 0: Response = [" + response + "]\n\n");
            theDomainName = this.makeDomainName();
            System.out.println("domainCreate: Create " + theDomainName + " with no optional attributes");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString("ClientX");
            response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
            System.out.println("domainCreate: Create pending-approve.com and look for poll message");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("pending-approve.com");
            this.domain.setAuthString("ClientX");
            response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            this.session.setTransId("AB-12345");
            this.session.setPollOp("req");
            EPPResponse pollResponse = this.session.sendPoll();
            System.out.println("domainCreate: Poll Response = [" + pollResponse + "]\n\n");
            this.session.setPollOp("ack");
            this.session.setMsgID(pollResponse.getMsgQueue().getId());
            pollResponse = this.session.sendPoll();
            System.out.println("domainPoll: Poll Ack Response = [" + pollResponse + "]\n\n");
            System.out.println("domainCreate: Create pending-denied.com and look for poll message");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("pending-denied.com");
            this.domain.setAuthString("ClientX");
            response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            this.session.setTransId("AB-12345");
            this.session.setPollOp("req");
            pollResponse = this.session.sendPoll();
            System.out.println("domainCreate: Poll Response = [" + pollResponse + "]\n\n");
            this.session.setPollOp("ack");
            this.session.setMsgID(pollResponse.getMsgQueue().getId());
            pollResponse = this.session.sendPoll();
            System.out.println("domainPoll: Poll Ack Response = [" + pollResponse + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            this.domain.setTransId("ABC-12345-XYZ");
            theDomainName = this.makeDomainName();
            System.out.println("domainCreate: Create " + theDomainName + " with all optional attributes");
            this.domain.addDomainName(theDomainName);
            for (int i = 0; i <= 20; ++i) {
                this.domain.addHostName(this.makeHostName(theDomainName));
            }
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.addContact("SH0000", "admin");
                this.domain.addContact("SH0000", "tech");
                this.domain.addContact("SH0000", "billing");
            }
            this.domain.setPeriodLength(10);
            this.domain.setPeriodUnit("y");
            this.domain.setAuthString("ClientX");
            response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    public void domainDelete() {
        this.printStart("domainDelete");
        try {
            System.out.println("\ndomainDelete: Domain delete");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            EPPResponse response = this.domain.sendDelete();
            System.out.println("domainDelete: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainDelete");
    }

    public void domainRenew() {
        this.printStart("domainRenew");
        try {
            System.out.println("\ndomainRenew: Domain renew");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.domain.setPeriodLength(10);
            this.domain.setPeriodUnit("y");
            EPPDomainRenewResp response = this.domain.sendRenew();
            System.out.println("domainRenew: Response = [" + response + "]\n\n");
            System.out.println("domainRenew: name = " + response.getName());
            System.out.println("domainRenew: expiration date = " + response.getExpirationDate());
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainRenew");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\ndomainUpdate: Domain update");
            this.domain.setTransId("ABC-12345-XYZ");
            String theDomainName = this.makeDomainName();
            this.domain.addDomainName(theDomainName);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setUpdateAttrib(1, "SH0000", "billing", 1);
            }
            this.domain.setUpdateAttrib(0, this.makeHostName(theDomainName), 1);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 1);
            this.domain.setUpdateAttrib(0, this.makeHostName(theDomainName), 2);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 2);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setUpdateAttrib(1, "SH0000", "billing", 2);
            }
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdate");
    }

    public void domainPoll() {
        this.printStart("domainPoll");
        EPPResponse response = null;
        try {
            System.out.println("\ndomainPoll: Domain Poll");
            this.session.setTransId("AB-12345");
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            System.out.println("domainPoll: Response = [" + response + "]\n\n");
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            System.out.println("domainPoll: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException ex) {
            this.handleException(ex);
        }
        this.printEnd("domainPoll");
    }

    public void domainTransferQuery() {
        this.printStart("domainTransferQuery");
        try {
            System.out.println("\ndomainTransferQuery: Domain transfer query");
            this.domain.setTransferOpCode("query");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            EPPDomainTransferResp response = this.domain.sendTransfer();
            System.out.println("domainTransferQuery: Response = [" + response + "]\n\n");
            System.out.println("domainTransferQuery: name = " + response.getName());
            System.out.println("domainTransferQuery: request client = " + response.getRequestClient());
            System.out.println("domainTransferQuery: action client = " + response.getActionClient());
            System.out.println("domainTransferQuery: transfer status = " + response.getTransferStatus());
            System.out.println("domainTransferQuery: request date = " + response.getRequestDate());
            System.out.println("domainTransferQuery: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("domainTransferQuery: expiration date = " + response.getExpirationDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainTransferQuery");
    }

    public void domainTransfer() {
        EPPDomainTransferResp response;
        this.printStart("domainTransfer");
        try {
            System.out.println("\ndomainTransfer: Domain transfer request");
            this.domain.setTransferOpCode("request");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.setAuthString("ClientX");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setPeriodLength(10);
            this.domain.setPeriodUnit("y");
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
            System.out.println("domainTransfer: name = " + response.getName());
            System.out.println("domainTransfer: request client = " + response.getRequestClient());
            System.out.println("domainTransfer: action client = " + response.getActionClient());
            System.out.println("domainTransfer: transfer status = " + response.getTransferStatus());
            System.out.println("domainTransfer: request date = " + response.getRequestDate());
            System.out.println("domainTransfer: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("domainTransfer: expiration date = " + response.getExpirationDate());
            }
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\ndomainTransfer: Domain transfer request without Authorization Info String set");
            this.domain.setTransferOpCode("request");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndomainTransfer: Domain transfer cancel");
            this.domain.setTransferOpCode("cancel");
            this.domain.addDomainName(this.makeDomainName());
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndomainTransfer: Domain transfer reject");
            this.domain.setTransferOpCode("reject");
            this.domain.addDomainName(this.makeDomainName());
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndomainTransfer: Domain transfer approve");
            this.domain.setTransferOpCode("approve");
            this.domain.addDomainName(this.makeDomainName());
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

