/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryLanguageType
implements EPPCodecComponent {
    private static final long serialVersionUID = 5827887024830764234L;
    static final String ELM_NAME = "registry:language";
    static final String ELM_TABLE_NAME = "registry:table";
    static final String ELM_VARIANT_STRATEGY_NAME = "registry:variantStrategy";
    static final String ATTR_CODE = "code";
    public static final List VALID_VARIANT_STRATEGIES = new ArrayList();
    public static final String VARIANT_STRATEGY_BLOCKED = "blocked";
    public static final String VARIANT_STRATEGY_RESTRICTED = "restricted";
    public static final String VARIANT_STRATEGY_OPEN = "open";
    private String table = null;
    private String strategy = null;
    private String code = null;

    public EPPRegistryLanguageType() {
    }

    public EPPRegistryLanguageType(String code, String table, String variantStrategy) {
        this.code = code;
        this.table = table;
        this.strategy = variantStrategy;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.code == null || this.code.trim().length() == 0) {
            throw new EPPEncodeException("Invalide state on EPPRegistryLanguageType.encode: attribute code is required.");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute(ATTR_CODE, this.code);
        if (this.table != null) {
            EPPUtil.encodeString(aDocument, root, this.table, "http://www.verisign.com/epp/registry-1.0", ELM_TABLE_NAME);
        }
        if (this.strategy != null) {
            EPPUtil.encodeString(aDocument, root, this.strategy, "http://www.verisign.com/epp/registry-1.0", ELM_VARIANT_STRATEGY_NAME);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.code = aElement.getAttribute(ATTR_CODE);
        this.strategy = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_VARIANT_STRATEGY_NAME);
        this.table = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_TABLE_NAME);
    }

    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryLanguageType)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryLanguageType)) {
            return false;
        }
        EPPRegistryLanguageType theComp = (EPPRegistryLanguageType)aObject;
        if (!(this.code != null ? this.code.equals(theComp.code) : theComp.code == null)) {
            return false;
        }
        if (!(this.table != null ? this.table.equals(theComp.table) : theComp.table == null)) {
            return false;
        }
        return this.strategy != null ? this.strategy.equals(theComp.strategy) : theComp.strategy == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    static {
        VALID_VARIANT_STRATEGIES.add(VARIANT_STRATEGY_BLOCKED);
        VALID_VARIANT_STRATEGIES.add(VARIANT_STRATEGY_RESTRICTED);
        VALID_VARIANT_STRATEGIES.add(VARIANT_STRATEGY_OPEN);
    }
}

