/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistryReservedNames;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomainName
implements EPPCodecComponent {
    private static final long serialVersionUID = -3575272010031382087L;
    private static Logger cat = Logger.getLogger((String)EPPRegistryDomainName.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    static final String ELM_NAME = "registry:domainName";
    static final String ELM_MIN_LENGTH = "registry:minLength";
    static final String ELM_MAX_LENGTH = "registry:maxLength";
    static final String ELM_ALPHA_NUM_START = "registry:alphaNumStart";
    static final String ELM_ALPHA_NUM_END = "registry:alphaNumEnd";
    static final String ELM_ONLY_DNS_CHARS = "registry:onlyDnsChars";
    static final String ELM_REGEX = "regex";
    static final String ATTR_LEVEL = "level";
    private Integer level = null;
    private Integer minLength = null;
    private Integer maxLength = null;
    private Boolean alphaNumStart = Boolean.FALSE;
    private Boolean alphaNumEnd = Boolean.FALSE;
    private Boolean onlyDnsChars = Boolean.TRUE;
    private List regex = new ArrayList();
    private EPPRegistryReservedNames reservedNames = null;

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomainName.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute(ATTR_LEVEL, this.level.toString());
        if (this.minLength != null) {
            EPPUtil.encodeString(aDocument, root, this.minLength.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MIN_LENGTH);
        }
        if (this.maxLength != null) {
            EPPUtil.encodeString(aDocument, root, this.maxLength.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX_LENGTH);
        }
        if (this.alphaNumStart == null) {
            this.alphaNumStart = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.alphaNumStart.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_ALPHA_NUM_START);
        if (this.alphaNumEnd == null) {
            this.alphaNumEnd = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.alphaNumEnd.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_ALPHA_NUM_END);
        if (this.onlyDnsChars == null) {
            this.onlyDnsChars = Boolean.TRUE;
        }
        EPPUtil.encodeString(aDocument, root, this.onlyDnsChars.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_ONLY_DNS_CHARS);
        if (this.regex != null && this.regex.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.regex);
        }
        if (this.reservedNames != null) {
            EPPUtil.encodeComp(aDocument, root, this.reservedNames);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        String levelStr = null;
        try {
            levelStr = aElement.getAttribute(ATTR_LEVEL);
            this.level = Integer.valueOf(levelStr);
        }
        catch (NumberFormatException e) {
            throw new EPPDecodeException("Cannot decode level: " + levelStr + "." + e);
        }
        this.minLength = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MIN_LENGTH);
        this.maxLength = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX_LENGTH);
        this.alphaNumStart = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ALPHA_NUM_START);
        if (this.alphaNumStart == null) {
            this.alphaNumStart = Boolean.FALSE;
        }
        this.alphaNumEnd = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ALPHA_NUM_END);
        if (this.alphaNumEnd == null) {
            this.alphaNumEnd = Boolean.FALSE;
        }
        this.onlyDnsChars = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ONLY_DNS_CHARS);
        if (this.onlyDnsChars == null) {
            this.onlyDnsChars = Boolean.TRUE;
        }
        this.setRegex(EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGEX, EPPRegistryRegex.class));
        this.reservedNames = (EPPRegistryReservedNames)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:reservedNames", EPPRegistryReservedNames.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRegistryDomainName.decode: " + e);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomainName)) {
            return false;
        }
        EPPRegistryDomainName theComp = (EPPRegistryDomainName)aObject;
        if (!(this.level != null ? this.level.equals(theComp.level) : theComp.level == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): level not equal");
            return false;
        }
        if (!(this.minLength != null ? this.minLength.equals(theComp.minLength) : theComp.minLength == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): minLength not equal");
            return false;
        }
        if (!(this.maxLength != null ? this.maxLength.equals(theComp.maxLength) : theComp.maxLength == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): maxLength not equal");
            return false;
        }
        if (!(this.alphaNumStart != null ? this.alphaNumStart.equals(theComp.alphaNumStart) : theComp.alphaNumStart == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): alphaNumStart not equal");
            return false;
        }
        if (!(this.alphaNumEnd != null ? this.alphaNumEnd.equals(theComp.alphaNumEnd) : theComp.alphaNumEnd == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): alphaNumEnd not equal");
            return false;
        }
        if (!(this.onlyDnsChars != null ? this.onlyDnsChars.equals(theComp.onlyDnsChars) : theComp.onlyDnsChars == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): onlyDnsChars not equal");
            return false;
        }
        if (!(this.regex != null ? EPPUtil.equalLists(this.regex, theComp.regex) : theComp.regex == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): regex not equal");
            return false;
        }
        if (!(this.reservedNames != null ? this.reservedNames.equals(theComp.reservedNames) : theComp.reservedNames == null)) {
            cat.error((Object)"EPPRegistryDomainName.equals(): reservedNames not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.level == null || this.level < 2) {
            throw new EPPCodecException("level should exist and be greater than or equal to 2");
        }
        if (this.minLength != null && this.minLength < 1) {
            throw new EPPCodecException("minLength, if specified, should be greater than 0");
        }
        if (this.maxLength != null) {
            if (this.minLength != null) {
                if (this.maxLength < this.minLength) {
                    throw new EPPCodecException("maxLength, if specified, should be no less than minLength");
                }
            } else if (this.maxLength < 1) {
                throw new EPPCodecException("maxLength, if specified, should be greater than 0");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomainName clone = (EPPRegistryDomainName)super.clone();
        if (this.regex != null) {
            clone.regex = (List)((ArrayList)this.regex).clone();
        }
        if (this.reservedNames != null) {
            clone.reservedNames = (EPPRegistryReservedNames)this.reservedNames.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getAlphaNumStart() {
        return this.alphaNumStart;
    }

    public void setAlphaNumStart(Boolean alphaNumStart) {
        this.alphaNumStart = alphaNumStart;
    }

    public Boolean getAlphaNumEnd() {
        return this.alphaNumEnd;
    }

    public void setAlphaNumEnd(Boolean alphaNumEnd) {
        this.alphaNumEnd = alphaNumEnd;
    }

    public Boolean getOnlyDnsChars() {
        return this.onlyDnsChars;
    }

    public void setOnlyDnsChars(Boolean onlyDnsChars) {
        this.onlyDnsChars = onlyDnsChars;
    }

    public List getRegex() {
        return this.regex;
    }

    public void addRegex(EPPRegistryRegex re) {
        if (re != null) {
            re.setRootName(ELM_REGEX);
            if (this.regex == null) {
                this.regex = new ArrayList();
            }
            this.regex.add(re);
        }
    }

    public void setRegex(List regex) {
        if (regex != null) {
            for (EPPRegistryRegex re : regex) {
                re.setRootName(ELM_REGEX);
            }
        }
        this.regex = regex;
    }

    public EPPRegistryReservedNames getReservedNames() {
        return this.reservedNames;
    }

    public void setReservedNames(EPPRegistryReservedNames reservedNames) {
        this.reservedNames = reservedNames;
    }
}

