/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPHostStatus
implements EPPCodecComponent {
    public static final String ELM_STATUS_OK = "ok";
    public static final String ELM_STATUS_PENDING_DELETE = "pendingDelete";
    public static final String ELM_STATUS_PENDING_CREATE = "pendingCreate";
    public static final String ELM_STATUS_PENDING_UPDATE = "pendingUpdate";
    public static final String ELM_STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String ELM_STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String ELM_STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String ELM_STATUS_LINKED = "linked";
    public static final String ELM_STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String ELM_STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String ELM_DEFAULT_LANG = "en";
    static final String ELM_NAME = "host:status";
    static final String ELM_STATUS = "s";
    static final String ELM_LANG = "lang";
    private static Logger cat = Logger.getLogger((String)EPPHostStatus.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String status = "ok";
    private String lang = "en";
    private String description = null;

    public EPPHostStatus() {
    }

    public EPPHostStatus(String aStatus) {
        this.status = aStatus;
    }

    public EPPHostStatus(String aStatus, String aDesc) {
        this.status = aStatus;
        this.description = aDesc;
    }

    public EPPHostStatus(String aStatus, String aDesc, String aLang) {
        this.status = aStatus;
        this.description = aDesc;
        this.lang = aLang;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPHostStatus clone = null;
        clone = (EPPHostStatus)super.clone();
        return clone;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.status = aElement.getAttribute(ELM_STATUS);
        Node descNode = aElement.getFirstChild();
        if (descNode != null) {
            this.description = descNode.getNodeValue();
            String theLang = aElement.getAttribute(ELM_LANG);
            this.lang = theLang == null || theLang.equals("") ? ELM_DEFAULT_LANG : theLang;
        }
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute(ELM_STATUS, this.status);
        if (this.description != null) {
            if (!this.lang.equals(ELM_DEFAULT_LANG)) {
                root.setAttribute(ELM_LANG, this.lang);
            }
            Text descVal = aDocument.createTextNode(this.description);
            root.appendChild(descVal);
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostStatus)) {
            return false;
        }
        EPPHostStatus theComp = (EPPHostStatus)aObject;
        if (!this.status.equals(theComp.status)) {
            cat.error((Object)("Status " + this.status + " != " + theComp.status));
            return false;
        }
        if (!(this.description != null ? this.description.equals(theComp.description) : theComp.description == null)) {
            cat.error((Object)("Description " + this.description + " != " + theComp.description));
            return false;
        }
        if (!this.lang.equals(theComp.lang)) {
            cat.error((Object)("Lang " + this.lang + " != " + theComp.lang));
            return false;
        }
        return true;
    }

    public String getLang() {
        return this.lang;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String newStatus) {
        this.status = newStatus;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public void setLang(String newLang) {
        this.lang = newLang;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }
}

