/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostCheckCmd
extends EPPCheckCmd {
    static final String ELM_NAME = "host:check";
    private static final String ELM_HOST_NAME = "host:name";
    private Vector names;

    public EPPHostCheckCmd() {
        this.names = new Vector();
    }

    public EPPHostCheckCmd(String aTransId, String aName) {
        super(aTransId);
        this.names = new Vector();
        this.names.addElement(aName);
    }

    public EPPHostCheckCmd(String aTransId, Vector someNames) {
        super(aTransId);
        this.names = someNames;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.names.size() == 0) {
            throw new EPPEncodeException("No host names specified in EPPHostCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd");
        EPPUtil.encodeVector(aDocument, root, this.names, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.names = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        if (this.names == null) {
            this.names = new Vector();
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostCheckCmd theMap = (EPPHostCheckCmd)aObject;
        return EPPUtil.equalVectors(this.names, theMap.names);
    }

    public Object clone() throws CloneNotSupportedException {
        EPPHostCheckCmd clone = (EPPHostCheckCmd)super.clone();
        clone.names = (Vector)this.names.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public void setName(String aName) {
        this.names = new Vector();
        this.names.addElement(aName);
    }

    public Vector getNames() {
        return this.names;
    }

    public void setNames(Vector someNames) {
        this.names = someNames;
    }
}

