/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EPPServiceMenu
implements EPPCodecComponent {
    public boolean OBJ_SERVICE = false;
    public boolean EXT_SERVICE = false;
    private Vector versions = new Vector();
    private Vector langs;
    private Vector services;
    private Vector extservices;
    private final String ELM_NAME = "svcMenu";
    private final String ELM_VERSION = "version";
    private final String ELM_LANG = "lang";
    private final String ELM_OBJURI = "objURI";
    private final String ELM_EXT = "svcExtension";
    private final String ELM_EXTURI = "extURI";

    public EPPServiceMenu() {
        this.versions.addElement("1.0");
        this.langs = new Vector();
        this.langs.addElement("en");
        this.services = EPPFactory.getInstance().getServices();
        this.extservices = EPPFactory.getInstance().getExtensions();
    }

    public Vector getVersions() {
        return this.versions;
    }

    public void setVersions(Vector someVersions) {
        this.versions = someVersions;
    }

    public String getVersion() {
        String retVal = null;
        if (this.versions.size() == 1) {
            retVal = (String)this.versions.elementAt(0);
        }
        return retVal;
    }

    public void setVersion(String aVersion) {
        this.versions = new Vector();
        this.versions.addElement(aVersion);
    }

    public Vector getLangs() {
        return this.langs;
    }

    public void setLangs(Vector someLangs) {
        this.langs = someLangs;
    }

    public String getLang() {
        String retVal = null;
        if (this.langs.size() == 1) {
            retVal = (String)this.langs.elementAt(0);
        }
        return retVal;
    }

    public void setLang(String aLang) {
        this.langs = new Vector();
        this.langs.addElement(aLang);
    }

    public Vector getObjectServices() {
        return this.services;
    }

    public void setObjectServices(Vector someObjServices) {
        this.services = someObjServices;
    }

    public Vector getExtensionServices() {
        return this.extservices;
    }

    public void setExtensionServices(Vector someExtServices) {
        this.extservices = someExtServices;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", "svcMenu");
        EPPUtil.encodeVector(aDocument, root, this.versions, "urn:ietf:params:xml:ns:epp-1.0", "version");
        EPPUtil.encodeVector(aDocument, root, this.langs, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        EPPUtil.encodeCompVector(aDocument, root, this.services);
        if (this.extservices != null && this.extservices.elements().hasMoreElements()) {
            Element svcExtension = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", "svcExtension");
            EPPUtil.encodeCompVector(aDocument, svcExtension, this.extservices);
            root.appendChild(svcExtension);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.versions = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", "version");
        this.langs = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        this.services = new Vector();
        this.extservices = new Vector();
        NodeList serviceElms = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("objURI"));
        for (int i = 0; i < serviceElms.getLength(); ++i) {
            EPPService objService = new EPPService();
            objService.setServiceType(0);
            objService.decode((Element)serviceElms.item(i));
            this.services.addElement(objService);
        }
        NodeList svcExtensionNodeList = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("svcExtension"));
        if (svcExtensionNodeList.getLength() != 0) {
            Element svcExtension = null;
            for (int i = 0; i < svcExtensionNodeList.getLength(); ++i) {
                svcExtension = (Element)svcExtensionNodeList.item(i);
                NodeList extensionElms = svcExtension.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("extURI"));
                for (int k = 0; k < extensionElms.getLength(); ++k) {
                    EPPService extService = new EPPService();
                    extService.setServiceType(1);
                    extService.decode((Element)extensionElms.item(k));
                    this.extservices.addElement(extService);
                }
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPServiceMenu)) {
            return false;
        }
        EPPServiceMenu theServiceMenu = (EPPServiceMenu)aObject;
        if (!EPPUtil.equalVectors(this.versions, theServiceMenu.versions)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.langs, theServiceMenu.langs)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.services, theServiceMenu.services)) {
            return false;
        }
        return EPPUtil.equalVectors(this.extservices, theServiceMenu.extservices);
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPServiceMenu clone = null;
        clone = (EPPServiceMenu)super.clone();
        clone.versions = (Vector)this.versions.clone();
        clone.langs = (Vector)this.langs.clone();
        clone.services = (Vector)this.services.clone();
        for (i = 0; i < this.services.size(); ++i) {
            clone.services.setElementAt(((EPPService)this.services.elementAt(i)).clone(), i);
        }
        if (this.extservices != null && this.extservices.elements().hasMoreElements()) {
            clone.extservices = (Vector)this.extservices.clone();
            for (i = 0; i < this.extservices.size(); ++i) {
                clone.extservices.setElementAt(((EPPService)this.extservices.elementAt(i)).clone(), i);
            }
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

