/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EPPMsgQueue
implements EPPCodecComponent {
    public static final String DEFAULT_LANG = "en";
    static final String ELM_NAME = "msgQ";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_ID = "id";
    private static final String ELM_QDATE = "qDate";
    private static final String ELM_MSG = "msg";
    private static final String ATTR_LANG = "lang";
    private static Logger cat = Logger.getLogger((String)EPPMsgQueue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private Long count = null;
    private String id = null;
    private Date qDate = null;
    private String lang = "en";
    private String msg = null;
    private NodeList msgNodeList = null;

    public EPPMsgQueue() {
    }

    public EPPMsgQueue(Long aCount, String aId) {
        this.count = aCount;
        this.id = aId;
    }

    public EPPMsgQueue(Long aCount, String aId, Date aQDate, String aMsg) {
        this.count = aCount;
        this.id = aId;
        this.qDate = aQDate;
        this.msg = aMsg;
    }

    public EPPMsgQueue(Long aCount, String aId, Date aQDate, NodeList aMsgNodeList) {
        this.count = aCount;
        this.id = aId;
        this.qDate = aQDate;
        this.msgNodeList = aMsgNodeList;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long aCount) {
        this.count = aCount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public Date getQDate() {
        return this.qDate;
    }

    public void setQDate(Date aDate) {
        this.qDate = aDate;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null || aLang.equals("") ? DEFAULT_LANG : aLang;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String aMsg) {
        this.msg = aMsg;
    }

    public NodeList getMsgNodeList() {
        return this.msgNodeList;
    }

    public void setMsgNodeList(NodeList aMsgNodeList) {
        this.msgNodeList = aMsgNodeList;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.count == null || this.id == null) {
            cat.error((Object)"EPPMsgQueue.encode(): required attributes count and id must be set");
            throw new EPPEncodeException("EPPMsgQueue required attributes count and id must be set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        root.setAttribute(ATTR_COUNT, this.count.toString());
        root.setAttribute(ATTR_ID, this.id);
        if (this.qDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.qDate, "urn:ietf:params:xml:ns:epp-1.0", ELM_QDATE);
        }
        Element msgElm = null;
        if (this.msg != null) {
            msgElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_MSG);
            Text currVal = aDocument.createTextNode(this.msg);
            msgElm.appendChild(currVal);
        } else if (this.msgNodeList != null) {
            msgElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_MSG);
            for (int i = 0; i < this.msgNodeList.getLength(); ++i) {
                Node clonedNode = aDocument.importNode(this.msgNodeList.item(i), true);
                msgElm.appendChild(clonedNode);
            }
        }
        if (msgElm != null) {
            root.appendChild(msgElm);
            if (!this.lang.equals(DEFAULT_LANG)) {
                msgElm.setAttribute(ATTR_LANG, this.lang);
            }
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.count = new Long(aElement.getAttribute(ATTR_COUNT));
        this.id = aElement.getAttribute(ATTR_ID);
        this.qDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_QDATE);
        Element theMsgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_MSG);
        if (theMsgElm != null) {
            NodeList theMsgNodes = theMsgElm.getChildNodes();
            if (theMsgNodes.getLength() > 1 || theMsgNodes.getLength() == 1 && theMsgNodes.item(0).getNodeType() != 3) {
                this.msg = null;
                Node theCurrNode = theMsgNodes.item(0);
                while (theCurrNode != null) {
                    Node theNextNode = theCurrNode.getNextSibling();
                    if (theCurrNode.getNodeType() == 3 && theCurrNode.getNodeValue().trim().length() == 0) {
                        theCurrNode.getParentNode().removeChild(theCurrNode);
                    }
                    theCurrNode = theNextNode;
                }
                this.msgNodeList = theMsgNodes;
            } else if (theMsgNodes.getLength() == 1 && theMsgNodes.item(0).getNodeType() == 3) {
                this.msgNodeList = null;
                this.msg = ((Text)theMsgNodes.item(0)).getNodeValue();
            } else {
                this.msg = "";
                this.msgNodeList = null;
            }
            this.setLang(theMsgElm.getAttribute(ATTR_LANG));
        } else {
            this.msg = null;
            this.msgNodeList = null;
            this.lang = DEFAULT_LANG;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMsgQueue)) {
            cat.error((Object)("EPPMsgQueue.equals(): " + aObject.getClass().getName() + " not EPPMsgQueue instance"));
            return false;
        }
        EPPMsgQueue theMsgQueue = (EPPMsgQueue)aObject;
        if (!(this.count != null ? this.count.equals(theMsgQueue.count) : theMsgQueue.count == null)) {
            cat.error((Object)"EPPMsgQueue.equals(): count not equal");
            return false;
        }
        if (!(this.id != null ? this.id.equals(theMsgQueue.id) : theMsgQueue.id == null)) {
            cat.error((Object)"EPPMsgQueue.equals(): id not equal");
            return false;
        }
        if (!(this.qDate != null ? this.qDate.equals(theMsgQueue.qDate) : theMsgQueue.qDate == null)) {
            cat.error((Object)"EPPMsgQueue.equals(): qDate not equal");
            return false;
        }
        if (!(this.msg != null ? this.msg.equals(theMsgQueue.msg) : theMsgQueue.msg == null)) {
            cat.error((Object)"EPPMsgQueue.equals(): msg not equal");
            return false;
        }
        if (this.msgNodeList != null) {
            if (theMsgQueue.msgNodeList == null) {
                cat.error((Object)"EPPMsgQueue.equals(): msgNodeList not equal, one is null");
                return false;
            }
            if (this.msgNodeList.getLength() != theMsgQueue.msgNodeList.getLength()) {
                cat.error((Object)("EPPMsgQueue.equals(): msgNodeList not equal, lengths are different (this = " + this.msgNodeList.getLength() + " to = " + theMsgQueue.msgNodeList.getLength() + ")"));
                return false;
            }
            for (int i = 0; i < this.msgNodeList.getLength(); ++i) {
                if (this.msgNodeList.item(i).getNodeType() == theMsgQueue.msgNodeList.item(i).getNodeType()) continue;
                cat.error((Object)"EPPMsgQueue.equals(): msgNodeList not equal, node types not equal");
                return false;
            }
        }
        if (!this.lang.equals(theMsgQueue.lang)) {
            cat.error((Object)"EPPMsgQueue.equals(): lang not equal");
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPMsgQueue clone = null;
        clone = (EPPMsgQueue)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

