/***********************************************************
Copyright (C) 2013 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;

/**
 * Defines the length of time that a domain object will remain in the
 * redemptionPeriod status unless the restore request command is received.
 * 
 * @author ljia
 * @version 1.4
 * 
 * @see com.verisign.epp.codec.registry.EPPRegistryRGP
 */
public class EPPRegistryRedemptionPeriodType extends EPPRegistryPeriodType {
	private static final long serialVersionUID = 9160119198962855561L;

	/**
	 * XML Element Name of <code>EPPRegistryRedemptionPeriodType</code> root
	 * element.
	 */
	public static final String ELM_NAME = "registry:redemptionPeriod";

	/**
	 * Default constructor. Must call {@link #setNumber(Integer)} and
	 * {@link #setUnit(String)} before calling
	 * {@link #encode(org.w3c.dom.Document)} method.
	 */
	public EPPRegistryRedemptionPeriodType() {
		super();
		this.rootName = ELM_NAME;
	}

	/**
	 * Constructs an instance of {@code EPPRegistryRedemptionPeriodType} with
	 * {@code number} and {@code unit}.
	 * 
	 * @param number
	 *            number must be > 0
	 * @param unit
	 *            unit must be one of "y", "m", "d", or "h"
	 */
	public EPPRegistryRedemptionPeriodType(Integer number, String unit) {
		this();
		this.number = number;
		this.unit = unit;
	}

	/**
	 * Constructs an instance of {@code EPPRegistryRedemptionPeriodType} with
	 * {@code number} and {@code unit}.
	 * 
	 * @param number
	 *            number must be > 0
	 * @param unit
	 *            unit must be one of "y", "m", "d", or "h"
	 */
	public EPPRegistryRedemptionPeriodType(int number, String unit) {
		this();
		this.number = new Integer(number);
		this.unit = unit;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.verisign.epp.codec.registry.EPPRegistryPeriodType#equals(java.lang
	 * .Object)
	 */
	public boolean equals(Object aObject) {
		return super.equals(aObject);
	}

	/**
	 * Extra validation rules on top of {@link EPPRegistryRedemptionPeriodType}:
	 * {@code number} must be greater than "0"; {@code unit} must be one of "y",
	 * "m", "d" or "h".
	 */
	void extraValidate() throws EPPCodecException {
		int n = number.intValue();
		if (n <= 0) {
			throw new EPPCodecException(getRootName()
					+ ": number should be greater than 0");
		}
		if (!VALID_UNITS.contains(unit)) {
			throw new EPPCodecException(getRootName()
					+ ": invalid unit. Valid values: y/m/d/h");
		}
	}
}
