/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.sql.PoolManConnection;
import com.codestudio.sql.PoolManDataSource;
import com.codestudio.sql.PoolManPreparedStatement;
import com.codestudio.util.JDBCPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import com.codestudio.util.SQLCache;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;

public class JDBCPool
extends ObjectPool
implements ConnectionEventListener {
    private PoolManDataSource datasource;
    private boolean deployedDataSource = false;
    private JDBCPoolMetaData info = (JDBCPoolMetaData)this.metadata;
    private SQLCache sqlcache;
    private Hashtable preparedStatementPool = new Hashtable();

    public JDBCPool(PoolMetaData poolMetaData) {
        super(poolMetaData);
        if (null != this.info.getJNDIName()) {
            this.datasource = new PoolManDataSource(this.info.getDbname(), this.info.getJNDIName());
        } else {
            this.log("JDBCPool: No JNDI name specified, not binding to Naming");
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            this.log("JDBCPool: Exception while initializing", exception);
        }
    }

    public void init() throws Exception {
        String string = this.info.getInitialConnectionSQL();
        super.init();
        if (this.info.isCacheEnabled()) {
            this.sqlcache = new SQLCache(this, this.info.getCacheSize(), this.info.getCacheRefreshInterval());
        }
        if (this.info.getInitialPoolSQL() != null) {
            try {
                PoolManConnection poolManConnection = (PoolManConnection)this.create();
                Connection connection = poolManConnection.getPhysicalConnection();
                Statement statement = connection.createStatement();
                statement.execute(this.info.getInitialPoolSQL());
            }
            catch (SQLException sQLException) {
                throw new SQLException("Init Pool SQL suffered a SQLException: " + sQLException);
            }
        }
        this.info.setInitialConnectionSQL(string);
        this.deployDataSource();
    }

    public void setDataSource(PoolManDataSource poolManDataSource) {
        this.datasource = poolManDataSource;
    }

    public DataSource getDataSource() {
        if (this.datasource == null) {
            throw new NullPointerException(this.info.getDbname() + " has no associated DataSource.");
        }
        return this.datasource;
    }

    public void deployDataSource() {
        if (this.datasource == null) {
            return;
        }
        try {
            InitialContext initialContext = new InitialContext();
            String string = this.info.getJNDIName();
            initialContext.rebind(string, (Object)this.datasource);
            this.deployedDataSource = true;
            this.log("DataSource bound to JNDI under name " + string);
        }
        catch (Exception exception) {
            this.debug("PoolMan JDBCPool unable to locate a default JNDI provider, DataSource is still available -- for example, get the DataSource via PoolMan.findDataSource(" + this.info.getDbname() + ") --  " + "but is not available through JNDI: " + exception.getMessage());
        }
    }

    public void undeployDataSource() {
        if (this.datasource == null) {
            return;
        }
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.unbind(this.info.getJNDIName());
            this.deployedDataSource = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isDataSourceDeployed() {
        return this.deployedDataSource;
    }

    public void setCache(SQLCache sQLCache) {
        this.sqlcache = sQLCache;
    }

    public SQLCache getCache() {
        return this.sqlcache;
    }

    public boolean usingCache() {
        return this.sqlcache != null;
    }

    public void refreshCache() {
        if (this.usingCache()) {
            this.sqlcache.forceRefresh();
        }
    }

    public String getDriver() {
        return this.info.getDriver();
    }

    public String getURL() {
        return this.info.getURL();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public String getPassword() {
        return this.info.getPassword();
    }

    public int getTransactionIsolation() {
        return this.info.getIsolationLevel();
    }

    public boolean isUsingNativeResults() {
        return this.info.isNativeResults();
    }

    public void checkCredentials(String string, String string2) throws SQLException {
        if (this.info.getUserName().equals(string) && this.info.getPassword().equals(string2)) {
            throw new SQLException("Invalid Username/Password: " + string + "/" + string2);
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.debug("JDBCPool received a ConnectionClosed Event, returning connection to pool");
        this.returnConnection((PoolManConnection)connectionEvent.getSource());
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.log("Received Connection Error event from a conection in pool " + this.info.getName());
        if (this.info.isRemoveOnExceptions()) {
            try {
                PoolManConnection poolManConnection = (PoolManConnection)connectionEvent.getSource();
                Connection connection = poolManConnection.getPhysicalConnection();
                connection.close();
                this.returnConnection(poolManConnection);
                this.log("removeOnExceptions == true, closed connection");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected Object create() throws SQLException {
        if (this.info.getDriver() == null || this.info.getURL() == null) {
            throw new SQLException("No Driver and/or URL found!");
        }
        try {
            Object object;
            Driver driver = (Driver)Class.forName(this.info.getDriver()).newInstance();
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", this.info.getUserName());
            ((Hashtable)properties).put("password", this.info.getPassword());
            if (!driver.acceptsURL(this.info.getURL())) {
                throw new SQLException("Driver cannot accept URL: " + this.info.getURL());
            }
            Connection connection = driver.connect(this.info.getURL(), properties);
            connection.setTransactionIsolation(this.info.getIsolationLevel());
            connection.setAutoCommit(true);
            if (this.info.getInitialConnectionSQL() != null) {
                try {
                    object = connection.createStatement();
                    object.execute(this.info.getInitialConnectionSQL());
                    object.close();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException("Init SQL Suffered a SQLException: " + sQLException);
                }
            }
            object = new PoolManConnection(connection, this);
            ((PoolManConnection)object).addConnectionEventListener(this);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "Looks like the driver for your database was not found. Please verify that it is in your CLASSPATH and listed properly in the poolman.xml file.";
            this.log(string, classNotFoundException);
            throw new SQLException(string);
        }
        catch (SQLException sQLException) {
            String string = "SQLException occurred in JDBCPool: " + sQLException.toString() + "\nparams: " + this.info.getDriver() + ", " + this.info.getURL() + ". Please check your username, password " + "and other connectivity info.";
            this.log(string, sQLException);
            throw new SQLException(string);
        }
        catch (Exception exception) {
            this.log(exception.getMessage(), exception);
            throw new SQLException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validate(Object object) {
        boolean bl = false;
        PoolManConnection poolManConnection = (PoolManConnection)object;
        if (this.info.getValidationQuery() != null) {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    connection = poolManConnection.getPhysicalConnection();
                    statement = connection.createStatement();
                    statement.execute(this.info.getValidationQuery());
                    bl = true;
                }
                catch (Exception exception) {
                    this.debug("Failed to validate Connection using validationQuery: " + this.info.getValidationQuery(), exception);
                    Object var9_9 = null;
                    JDBCPool.closeResources(statement, resultSet);
                    return bl;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                JDBCPool.closeResources(statement, resultSet);
                throw throwable;
            }
            JDBCPool.closeResources(statement, resultSet);
            return bl;
        }
        try {
            if (poolManConnection.isClosed()) return false;
            return true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    protected void expire(Object object) {
        try {
            PoolManConnection poolManConnection = (PoolManConnection)object;
            poolManConnection.removeConnectionEventListener(this);
            try {
                poolManConnection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            poolManConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
    }

    public Connection requestConnection() throws SQLException {
        try {
            PoolManConnection poolManConnection = (PoolManConnection)super.checkOut();
            return poolManConnection.getConnection();
        }
        catch (SQLException sQLException) {
            this.log(sQLException.getMessage(), sQLException);
            throw new SQLException(sQLException.getMessage());
        }
        catch (Exception exception) {
            this.log("A non-SQL error occurred when requesting a connection:", exception);
            throw new SQLException(exception.getMessage());
        }
    }

    public void returnConnection(PoolManConnection poolManConnection) {
        poolManConnection.clean();
        super.checkIn(poolManConnection);
    }

    public PreparedStatement requestPooledStatement(String string) {
        PreparedStatement preparedStatement = null;
        if (this.preparedStatementPool.containsKey(string)) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = (ArrayList)this.preparedStatementPool.get(string);
            synchronized (arrayList2) {
                if (arrayList.size() > 0) {
                    preparedStatement = (PreparedStatement)arrayList.remove(0);
                }
            }
        }
        return preparedStatement;
    }

    public void returnPooledStatement(PoolManPreparedStatement poolManPreparedStatement) {
        ArrayList arrayList = null;
        if (this.info.isPoolPreparedStatements()) {
            arrayList = this.preparedStatementPool.containsKey(poolManPreparedStatement.getSQL()) ? (ArrayList)this.preparedStatementPool.get(poolManPreparedStatement.getSQL()) : new ArrayList();
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                arrayList.add(poolManPreparedStatement.getNativePreparedStatement());
                this.preparedStatementPool.put(poolManPreparedStatement.getSQL(), arrayList);
            }
        } else {
            JDBCPool.closeStatement(poolManPreparedStatement.getNativePreparedStatement());
        }
    }

    public int numStatementPools() {
        return this.preparedStatementPool.size();
    }

    public int numPooledStatements(String string) {
        int n = 0;
        if (this.preparedStatementPool.containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.preparedStatementPool.get(string);
            n = arrayList.size();
        }
        return n;
    }

    public void closeAllResources() {
        this.undeployDataSource();
        super.closeAllResources();
    }

    public static void closeResources(Connection connection, Statement statement, ResultSet resultSet) {
        JDBCPool.closeResultSet(resultSet);
        JDBCPool.closeStatement(statement);
        JDBCPool.closeConnection(connection);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        JDBCPool.closeResultSet(resultSet);
        JDBCPool.closeStatement(statement);
    }

    public static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        connection = null;
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement = null;
    }

    public static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resultSet = null;
    }
}

