/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.sql.PoolManCallableStatement;
import com.codestudio.sql.PoolManConnectionHandle;
import com.codestudio.sql.PoolManPreparedStatement;
import com.codestudio.sql.PoolManStatement;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PooledObject;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PoolManConnection
implements PooledConnection,
PooledObject {
    private JDBCPool mypool;
    private Connection con;
    private WeakHashMap openstatements;
    private ArrayList listeners;
    private PoolManConnectionHandle handle;
    private boolean readOnly = false;

    public PoolManConnection(Connection connection, ObjectPool objectPool) {
        this.con = connection;
        this.mypool = (JDBCPool)objectPool;
        this.openstatements = new WeakHashMap();
        try {
            if (connection.isReadOnly()) {
                this.readOnly = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeAllResources() {
        this.clean();
    }

    public void closeAll() {
    }

    public void removeOpenStatement(PoolManStatement poolManStatement) {
        if (this.openstatements.containsKey(poolManStatement)) {
            this.openstatements.remove(poolManStatement);
        }
    }

    public void clean() {
        if (this.handle != null) {
            this.handle.clearConnection();
            this.handle = null;
        }
        try {
            this.con.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTransactionIsolation(this.mypool.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.con.setReadOnly(this.readOnly);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Iterator iterator = ((AbstractMap)this.openstatements).keySet().iterator();
        while (iterator.hasNext()) {
            PoolManStatement poolManStatement = (PoolManStatement)iterator.next();
            poolManStatement.clean();
            JDBCPool.closeStatement(poolManStatement);
        }
    }

    public void touch() {
        this.mypool.updateLocked(this);
    }

    public ObjectPool getPool() {
        return this.mypool;
    }

    public Connection getConnection() throws SQLException {
        this.handle = new PoolManConnectionHandle(this);
        return this.handle;
    }

    public Connection getPhysicalConnection() {
        return this.con;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (null == this.listeners) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            ((AbstractCollection)this.listeners).remove(connectionEventListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendCloseEvent() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(n);
            connectionEventListener.connectionClosed(connectionEvent);
            ++n;
        }
    }

    private void sendErrorEvent(SQLException sQLException) {
        this.clean();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        int n = 0;
        while (n < this.listeners.size()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(n);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
            ++n;
        }
    }

    public Statement createStatement() throws SQLException {
        this.touch();
        try {
            Statement statement = this.con.createStatement();
            PoolManStatement poolManStatement = new PoolManStatement(this, statement, this.mypool);
            this.openstatements.put(poolManStatement, null);
            return poolManStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.touch();
        try {
            PreparedStatement preparedStatement = this.mypool.requestPooledStatement(string);
            if (preparedStatement == null) {
                preparedStatement = this.con.prepareStatement(string);
            }
            PoolManPreparedStatement poolManPreparedStatement = new PoolManPreparedStatement(this, preparedStatement, string, this.mypool);
            this.openstatements.put(poolManPreparedStatement, null);
            return poolManPreparedStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.touch();
        try {
            CallableStatement callableStatement = this.con.prepareCall(string);
            PoolManCallableStatement poolManCallableStatement = new PoolManCallableStatement(this, callableStatement, (ObjectPool)this.mypool);
            this.openstatements.put(poolManCallableStatement, null);
            return poolManCallableStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            String string2 = this.con.nativeSQL(string);
            return string2;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.con.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        try {
            this.con.commit();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.con.rollback();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        try {
            this.clean();
            this.con.close();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this.con.isClosed();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            return true;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.con.getMetaData();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.con.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.con.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.con.getCatalog();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.con.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.con.getWarnings();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.con.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.touch();
        try {
            Statement statement = null;
            try {
                statement = this.con.createStatement(n, n2);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (statement == null) {
                statement = this.con.createStatement();
            }
            PoolManStatement poolManStatement = new PoolManStatement(this, statement, this.mypool);
            poolManStatement.setResultSetType(n);
            poolManStatement.setResultSetConcurrency(n2);
            this.openstatements.put(poolManStatement, null);
            return poolManStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.touch();
        try {
            PoolManPreparedStatement poolManPreparedStatement = (PoolManPreparedStatement)this.prepareStatement(string);
            poolManPreparedStatement.setResultSetType(n);
            poolManPreparedStatement.setResultSetConcurrency(n2);
            this.openstatements.put(poolManPreparedStatement, null);
            return poolManPreparedStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.touch();
        try {
            CallableStatement callableStatement = this.con.prepareCall(string);
            PoolManCallableStatement poolManCallableStatement = new PoolManCallableStatement(this, callableStatement, (ObjectPool)this.mypool);
            poolManCallableStatement.setResultSetType(n);
            poolManCallableStatement.setResultSetConcurrency(n2);
            this.openstatements.put(poolManCallableStatement, null);
            return poolManCallableStatement;
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.sendErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public String toString() {
        return "PoolManConnection:[Pool:" + this.mypool.getPoolname() + ",OpenStatements:" + this.openstatements.size() + "]";
    }
}

