/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEntityResolver;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPXMLErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EPPXMLParser
extends DocumentBuilder {
    public static final String POOL = "EPP_XML_PARSER_POOL";
    private DocumentBuilder _parser = null;
    private static DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
    private static Logger cat;

    public EPPXMLParser() {
        try {
            this._parser = _factory.newDocumentBuilder();
            this._parser.setErrorHandler(new EPPXMLErrorHandler());
            this._parser.setEntityResolver(new EPPEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            cat.error((Object)("EPPXMLParser(): Error initializing parser: " + ex));
            ex.printStackTrace();
        }
    }

    public EPPXMLParser(boolean validateSchema) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validateSchema);
            factory.setNamespaceAware(true);
            this._parser = factory.newDocumentBuilder();
            this._parser.setErrorHandler(new EPPXMLErrorHandler());
            this._parser.setEntityResolver(new EPPEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            cat.error((Object)("EPPXMLParser(): Error initializing parser: " + ex));
            ex.printStackTrace();
        }
    }

    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    public boolean isNamespaceAware() {
        return this._parser.isNamespaceAware();
    }

    public boolean isValidating() {
        return this._parser.isValidating();
    }

    public Document parse(File aFile) throws SAXException, IOException {
        return this._parser.parse(aFile);
    }

    public Document parse(InputStream aStream) throws SAXException, IOException {
        return this._parser.parse(aStream);
    }

    public Document parse(InputSource aSource) throws SAXException, IOException {
        return this._parser.parse(aSource);
    }

    public Document parse(InputStream aStream, String aSystemId) throws SAXException, IOException {
        return this._parser.parse(aStream, aSystemId);
    }

    public Document parse(String aURI) throws SAXException, IOException {
        return this._parser.parse(aURI);
    }

    public void setEntityResolver(EntityResolver aResolver) {
        this._parser.setEntityResolver(aResolver);
    }

    public void setErrorHandler(ErrorHandler aHandler) {
        this._parser.setErrorHandler(aHandler);
    }

    public Document newDocument() {
        return this._parser.newDocument();
    }

    static {
        _factory.setNamespaceAware(true);
        _factory.setValidating(EPPEnv.getValidating());
        cat = Logger.getLogger((String)EPPXMLParser.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

