/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPServerThread
extends Thread {
    private static Logger cat = Logger.getLogger((String)EPPServerThread.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private Socket socket = null;
    private InputStream myInputStream = null;
    private OutputStream myOutputStream = null;
    private ServerEventHandler myHandler = null;

    public EPPServerThread(Socket newSocket, ServerEventHandler newHandler) throws IOException {
        super("EPPMultiServerThread");
        this.socket = newSocket;
        this.myHandler = newHandler;
        try {
            this.myInputStream = this.socket.getInputStream();
            this.myOutputStream = new BufferedOutputStream(this.socket.getOutputStream(), 20480);
        }
        catch (IOException myException) {
            myException.printStackTrace();
            throw new IOException(myException.getMessage());
        }
    }

    public void run() {
        cat.info((Object)"run(): enter");
        if (this.myHandler == null) {
            cat.error((Object)"The Server Handler is not Set");
            return;
        }
        try {
            ServerEventHandler myConHandler = (ServerEventHandler)this.myHandler.clone();
            myConHandler.handleConnection(this.myInputStream, this.myOutputStream);
        }
        catch (CloneNotSupportedException myException) {
            cat.error((Object)("Server Run : CloneNotSupportedException : " + myException.getMessage()), (Throwable)myException);
            return;
        }
        cat.info((Object)"run(): Closing socket");
        try {
            this.socket.close();
        }
        catch (IOException myException) {
            cat.error((Object)("Server Run : IOException When Closing the Connection : " + myException.getMessage()), (Throwable)myException);
            return;
        }
        cat.info((Object)"run(): exit");
    }
}

