/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class EPPSampleClient {
    public static void main(String[] args) throws IOException {
        String fromServer;
        Socket mySocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        EPPEnvSingle env = EPPEnvSingle.getInstance();
        try {
            env.initialize("EPP.config");
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEvnException is thrown :" + e.getMessage());
            System.exit(1);
        }
        try {
            try {
                mySocket = new Socket(EPPEnv.getServerName(), EPPEnv.getServerPort());
            }
            catch (EPPEnvException envException) {
                System.err.println("Could not get Envvariable : " + envException.getMessage());
                System.exit(1);
            }
            out = new PrintWriter(mySocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(mySocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host ");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }
        while ((fromServer = in.readLine()) != null) {
            System.out.println("Server: " + fromServer);
            if (fromServer.equals("Bye.")) break;
            out.println("Hello There Back");
            out.println("Bye.");
        }
        out.close();
        in.close();
        mySocket.close();
    }
}

