/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.whowas.EPPWhoWasHistory;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoCmd;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoResp;
import com.verisign.epp.codec.whowas.EPPWhoWasRecord;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPWhoWasHandler;
import com.verisign.epp.serverstub.SessionData;
import java.util.Calendar;
import java.util.Date;

public class WhoWasHandler
extends EPPWhoWasHandler {
    private static final String svrTransId = "SRV-43659";
    private static final String CREATE_OPERATION_ENTITY_TEST_NAME = "create-operation-history.com";
    private static final String CREATE_OPERATION_ENTITY_TEST_ROID = "create-rep";
    private static final String ALL_OPERATION_ENTITY_TEST_NAME = "all-operation-history.com";
    private static final String ALL_OPERATION_ENTITY_TEST_ROID = "all-rep";
    private static final String NON_EXISTING_ENTITY_TEST_NAME = "non-existing.com";
    private static final String NON_EXISTING_ENTITY_TEST_ROID = "non-existing";
    private static final String DEFAULT_ENTITY_NAME = "abc.com";
    private static final String DEFAULT_ENTITY_ROID = "EXAMPLE1-REP";

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2002);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    protected EPPEventResponse doWhoWasInfo(EPPEvent aEvent, Object aData) {
        EPPWhoWasInfoCmd theMessage = (EPPWhoWasInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPWhoWasInfoResp theResponse = new EPPWhoWasInfoResp(theTransId, theMessage.getWhowasType());
        theResponse.setResult(1000);
        String name = theMessage.getName();
        String roid = theMessage.getRoid();
        theResponse.setName(name);
        theResponse.setRoid(roid);
        EPPWhoWasHistory history = new EPPWhoWasHistory();
        if (CREATE_OPERATION_ENTITY_TEST_NAME.equalsIgnoreCase(name) || CREATE_OPERATION_ENTITY_TEST_ROID.equalsIgnoreCase(roid)) {
            if (name != null) {
                roid = CREATE_OPERATION_ENTITY_TEST_ROID;
            } else {
                name = CREATE_OPERATION_ENTITY_TEST_NAME;
            }
            EPPWhoWasRecord createRecord = new EPPWhoWasRecord(name, roid, new Date(), "CREATE", "ClientX", "Client X Corp");
            history.addRecord(createRecord);
        } else if (ALL_OPERATION_ENTITY_TEST_NAME.equalsIgnoreCase(name) || ALL_OPERATION_ENTITY_TEST_ROID.equalsIgnoreCase(roid)) {
            history = this.getAllOperationsHistory(name, roid);
        } else {
            if (NON_EXISTING_ENTITY_TEST_NAME.equalsIgnoreCase(name) || NON_EXISTING_ENTITY_TEST_ROID.equalsIgnoreCase(roid)) {
                EPPResponse eppResponse = new EPPResponse(theTransId);
                eppResponse.setResult(2303);
                return new EPPEventResponse(eppResponse);
            }
            if (name != null) {
                roid = DEFAULT_ENTITY_ROID;
            } else {
                name = DEFAULT_ENTITY_NAME;
            }
            EPPWhoWasRecord createRecord = new EPPWhoWasRecord(name, roid, new Date(), "CREATE", "ClientX", "Client X Corp");
            history.addRecord(createRecord);
        }
        theResponse.setHistory(history);
        return new EPPEventResponse(theResponse);
    }

    private EPPWhoWasHistory getAllOperationsHistory(String aName, String aRoid) {
        EPPWhoWasHistory history = new EPPWhoWasHistory();
        Calendar transactionDate = Calendar.getInstance();
        transactionDate.setTime(new Date());
        transactionDate.add(2, -12);
        if (aName != null) {
            aRoid = ALL_OPERATION_ENTITY_TEST_ROID;
        } else {
            aName = ALL_OPERATION_ENTITY_TEST_NAME;
        }
        EPPWhoWasRecord createRecord = new EPPWhoWasRecord(aName, aRoid, transactionDate.getTime(), "CREATE", "ClientX", "Client X Corp");
        transactionDate.add(2, 1);
        EPPWhoWasRecord deleteRecord = new EPPWhoWasRecord(aName, aRoid, transactionDate.getTime(), "DELETE", "ClientX", "Client X Corp");
        transactionDate.add(2, 1);
        EPPWhoWasRecord newCreateRecord = new EPPWhoWasRecord(aName, aRoid, transactionDate.getTime(), "CREATE", "ClientX", "Client X Corp");
        transactionDate.add(2, 1);
        EPPWhoWasRecord transferRecord = new EPPWhoWasRecord(aName, aRoid, transactionDate.getTime(), "TRANSFER", "ClientY", "Client Y Corp");
        transactionDate.add(2, 1);
        EPPWhoWasRecord serverTransferRecord = new EPPWhoWasRecord(aName, aRoid, transactionDate.getTime(), "SERVER TRANSFER", "ClientX", "Client X Corp");
        transactionDate.add(2, 1);
        history.addRecord(serverTransferRecord);
        history.addRecord(transferRecord);
        history.addRecord(newCreateRecord);
        history.addRecord(deleteRecord);
        history.addRecord(createRecord);
        return history;
    }
}

