/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import com.verisign.epp.codec.rgppoll.EPPRgpPollMapFactory;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.codec.rgppoll.EPPRgpPollStatus;
import com.verisign.epp.framework.EPPDomainHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class RgpDomainHandler
extends EPPDomainHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";
    private static Logger cat = Logger.getLogger((String)RgpDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public RgpDomainHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPRgpPollMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the EPPRgpPollMapFactory Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theMessage = (EPPDomainCheckCmd)aEvent.getMessage();
        Vector vNames = theMessage.getNames();
        Enumeration eNames = vNames.elements();
        Vector<EPPDomainCheckResult> vResults = new Vector<EPPDomainCheckResult>();
        boolean known = true;
        while (eNames.hasMoreElements()) {
            String domainName = (String)eNames.nextElement();
            known = !known;
            vResults.addElement(new EPPDomainCheckResult(domainName, known));
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theMessage = (EPPDomainRenewCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theMessage = (EPPDomainDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPDomainCreateResp(transId, theMessage.getName(), new Date());
        if (theMessage.getName().equals("pending.com")) {
            EPPTransId pendingTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPDomainPendActionMsg thePollMsg = new EPPDomainPendActionMsg(transId, "pending.com", true, pendingTransId, new Date());
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainCreate: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
            theResponse.setResult(1001);
        } else {
            theResponse.setResult(1000);
        }
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.getOp().equals("request")) {
            EPPDomainTransferResp thePollMsg = new EPPDomainTransferResp();
            thePollMsg.setName("example");
            thePollMsg.setTransferStatus("pending");
            thePollMsg.setRequestClient("ClientX");
            thePollMsg.setRequestDate(new Date());
            thePollMsg.setActionClient("ClientY");
            thePollMsg.setActionDate(new Date());
            thePollMsg.setExpirationDate(new Date());
            thePollMsg.setResult(1000);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(transId, theMessage.getName());
        theResponse.setTransferStatus("pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(new Date());
        theResponse.setActionClient("ClientY");
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"RgpDomainHandler.doDomainUpdate(): enter");
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPResponse theResponse = null;
        EPPRgpExtUpdate rgpUpdate = (EPPRgpExtUpdate)theMessage.getExtension(EPPRgpExtUpdate.class);
        EPPTransId pendingTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (rgpUpdate != null) {
            if (rgpUpdate.getRestore().getOp().equals("report")) {
                cat.info((Object)"RgpDomainHandler.doDomainUpdate(): restore report");
                EPPRgpExtReport theReport = rgpUpdate.getRestore().getReport();
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): preData = " + theReport.getPreData()));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): postData = " + theReport.getPostData()));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): deleteTime = " + theReport.getDeleteTime()));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): restoreTime = " + theReport.getRestoreTime()));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): restoreReason = " + (theReport.getRestoreReason() != null ? theReport.getRestoreReason().getMessage() : "null")));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): statement1 = " + (theReport.getStatement1() != null ? theReport.getStatement1().getMessage() : "null")));
                cat.info((Object)("RgpDomainHandler.doDomainUpdate(): statement2 = " + (theReport.getStatement2() != null ? theReport.getStatement2().getMessage() : "null")));
            } else {
                cat.info((Object)"RgpDomainHandler.doDomainUpdate(): restore request");
                EPPRgpPollResponse thePollMsg = new EPPRgpPollResponse();
                thePollMsg.setName(theMessage.getName());
                thePollMsg.setReportDueDate(new Date(System.currentTimeMillis() + 3600L));
                thePollMsg.setTransId(pendingTransId);
                thePollMsg.setReqDate(new Date(System.currentTimeMillis()));
                thePollMsg.setStatus(new EPPRgpPollStatus("pendingRestore"));
                try {
                    EPPPollQueueMgr.getInstance().put(null, "http://www.verisign.com/epp/rgp-poll-1.0", thePollMsg, null);
                }
                catch (EPPPollQueueException ex) {
                    cat.error((Object)("doDomainUpdate: Error putting message [" + thePollMsg + "]"));
                    EPPResult theResult = new EPPResult(2400);
                    theResponse = new EPPResponse(pendingTransId, theResult);
                    return new EPPEventResponse(theResponse);
                }
            }
        } else {
            cat.error((Object)"doDomainUpdate: RGP extension NOT found");
            EPPResult theResult = new EPPResult(2306);
            theResponse = new EPPResponse(pendingTransId, theResult);
            return new EPPEventResponse(theResponse);
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        cat.debug((Object)"RgpDomainHandler.doDomainUpdate(): enter");
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theMessage = (EPPDomainInfoCmd)aEvent.getMessage();
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        statuses.addElement(new EPPDomainStatus("clientHold"));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(transId, roid, "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        Vector<String> theNses = new Vector<String>();
        theNses.addElement("ns1.example.com");
        theNses.addElement("ns2.example.com");
        theResponse.setNses(theNses);
        Vector<String> theHosts = new Vector<String>();
        theHosts.addElement("ns1.example.com");
        theHosts.addElement("ns2.example.com");
        theResponse.setHosts(theHosts);
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 1);
        theResponse.setExpirationDate(theCal.getTime());
        theResponse.setResult(1000);
        if (theMessage.getName().equalsIgnoreCase("graceperiod.com")) {
            EPPRgpExtInfData rgpExt = new EPPRgpExtInfData();
            EPPRgpExtStatus autoRenewPeriodStatus = new EPPRgpExtStatus("autoRenewPeriod");
            autoRenewPeriodStatus.setMessage("endDate=" + EPPUtil.encodeTimeInstant(new Date()));
            rgpExt.addStatus(autoRenewPeriodStatus);
            EPPRgpExtStatus renewPeriodStatus = new EPPRgpExtStatus("renewPeriod");
            renewPeriodStatus.setMessage("endDate=" + EPPUtil.encodeTimeInstant(new Date()));
            rgpExt.addStatus(renewPeriodStatus);
            theResponse.addExtension(rgpExt);
        } else {
            statuses = new Vector();
            statuses.addElement(new EPPDomainStatus("pendingDelete"));
            theResponse.setStatuses(statuses);
            EPPRgpExtInfData rgpExt = new EPPRgpExtInfData();
            EPPRgpExtStatus rgpStatus = new EPPRgpExtStatus();
            rgpStatus.setStatus("redemptionPeriod");
            rgpExt.addStatus(rgpStatus);
            theResponse.addExtension(rgpExt);
        }
        return new EPPEventResponse(theResponse);
    }
}

