/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPNameWatchHandler;
import com.verisign.epp.serverstub.SessionData;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class NameWatchHandler
extends EPPNameWatchHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "EXAMPLE1-REP";

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected EPPEventResponse doNameWatchRenew(EPPEvent aEvent, Object aData) {
        EPPNameWatchRenewCmd theMessage = (EPPNameWatchRenewCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        Calendar exDate = Calendar.getInstance();
        exDate.setTime(theMessage.getCurExpDate());
        exDate.add(1, theMessage.getPeriod().getPeriod());
        EPPNameWatchRenewResp theResponse = new EPPNameWatchRenewResp(transId, theMessage.getRoid(), exDate.getTime());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doNameWatchDelete(EPPEvent aEvent, Object aData) {
        EPPNameWatchDeleteCmd theMessage = (EPPNameWatchDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doNameWatchCreate(EPPEvent aEvent, Object aData) {
        EPPNameWatchCreateCmd theMessage = (EPPNameWatchCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPNameWatchCreateResp theResponse = null;
        theResponse = theMessage.getPeriod() == null ? new EPPNameWatchCreateResp(transId, theMessage.getName(), roid, new GregorianCalendar(1999, 4, 3).getTime()) : new EPPNameWatchCreateResp(transId, theMessage.getName(), roid, new GregorianCalendar(1999, 4, 3).getTime(), new GregorianCalendar(1999 + theMessage.getPeriod().getPeriod(), 4, 3).getTime());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doNameWatchTransfer(EPPEvent aEvent, Object aData) {
        EPPNameWatchTransferCmd theMessage = (EPPNameWatchTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPNameWatchTransferResp theResponse = new EPPNameWatchTransferResp(transId, theMessage.getRoid());
        theResponse.setTransferStatus("pending");
        Calendar reDate = Calendar.getInstance();
        reDate.setTime(new GregorianCalendar(2000, 6, 8).getTime());
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(reDate.getTime());
        theResponse.setActionClient("ClientY");
        Calendar acDate = Calendar.getInstance();
        acDate.setTime(reDate.getTime());
        acDate.add(5, 5);
        theResponse.setActionDate(acDate.getTime());
        Calendar exDate = Calendar.getInstance();
        exDate.setTime(reDate.getTime());
        if (theMessage.getPeriod() != null) {
            exDate.add(1, theMessage.getPeriod().getPeriod());
        } else {
            exDate.add(1, 1);
        }
        theResponse.setExpirationDate(exDate.getTime());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doNameWatchUpdate(EPPEvent aEvent, Object aData) {
        EPPNameWatchUpdateCmd theMessage = (EPPNameWatchUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doNameWatchInfo(EPPEvent aEvent, Object aData) {
        EPPNameWatchInfoCmd theMessage = (EPPNameWatchInfoCmd)aEvent.getMessage();
        Vector<EPPNameWatchStatus> statuses = new Vector<EPPNameWatchStatus>();
        statuses.addElement(new EPPNameWatchStatus("ok"));
        statuses.addElement(new EPPNameWatchStatus("clientHold"));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 1);
        EPPNameWatchInfoResp theResponse = new EPPNameWatchInfoResp(transId, "doe", theMessage.getRoid(), "jd1234", new EPPNameWatchRptTo("weekly", "jdoe@example.com"), statuses, "ClientX", "ClientY", new GregorianCalendar(1999, 4, 3).getTime(), theCal.getTime());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }
}

