/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPConFactorySingle;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPXMLStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPSession {
    public static final String OP_REQ = "req";
    public static final String OP_ACK = "ack";
    private static final Logger cat = Logger.getLogger((String)EPPSession.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final int MODE_SYNC = 0;
    public static final int MODE_ASYNC = 1;
    protected EPPCodec myCodec = EPPCodec.getInstance();
    protected String myTransId = null;
    protected String myVersion = null;
    protected String myLanguage = null;
    protected String myClientID = null;
    protected String myPassword = null;
    protected String myNewPassword = null;
    protected EPPResponse myResponse = null;
    protected Vector myServices = null;
    protected Vector myExtensionServices = null;
    protected EPPClientCon myConnection = null;
    protected InputStream myInputStream = null;
    protected OutputStream myOutputStream = null;
    protected EPPXMLStream myXMLStream = null;
    protected String myPollOp = null;
    protected String msgID = null;
    private String statusTransId = null;
    private String statusCommandType = null;
    private int mode = 0;

    public EPPSession() throws EPPCommandException {
        this.init();
    }

    public EPPSession(String aHostName, int aPortNumber) throws EPPCommandException {
        this.init(aHostName, aPortNumber, null);
    }

    public EPPSession(String aHostName, int aPortNumber, String aClientHostName) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aClientHostName, null);
    }

    public EPPSession(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aSSLContext);
    }

    public EPPSession(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aClientHostName, aSSLContext);
    }

    protected void init() throws EPPCommandException {
        cat.debug((Object)"init(): enter");
        this.myConnection = this.getConnection();
        try {
            this.myConnection.initialize();
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(): Unable to initialize connection to the EPP Server: " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server: " + ex);
        }
        this.initStreams();
        cat.debug((Object)"init(): exit");
    }

    protected void init(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPCommandException {
        cat.debug((Object)"init(String, int, EPPSSLContext): enter");
        this.myConnection = this.getConnection();
        try {
            this.myConnection.initialize(aHostName, aPortNumber, aSSLContext);
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(String, int, EPPSSLContext): Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + ": " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + ": " + ex);
        }
        this.initStreams();
        cat.debug((Object)"init(String, int, EPPSSLContext): exit");
    }

    protected void init(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPCommandException {
        cat.debug((Object)"init(int, int, String, EPPSSLContext): enter");
        this.myConnection = this.getConnection();
        try {
            this.myConnection.initialize(aHostName, aPortNumber, aClientHostName, aSSLContext);
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(int, int, String, EPPSSLContext): Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + " from client host " + aClientHostName + ": " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + " from client host " + aClientHostName + ": " + ex);
        }
        this.initStreams();
        cat.debug((Object)"init(int, int, String, EPPSSLContext): exit");
    }

    protected EPPClientCon getConnection() throws EPPCommandException {
        cat.debug((Object)"getConnection(): enter");
        EPPClientCon theConnection = null;
        try {
            theConnection = EPPConFactorySingle.getInstance().getEPPConnection();
        }
        catch (EPPConException ex) {
            cat.error((Object)("getConnection(): Unable to get connection instance from factory: " + ex));
            throw new EPPCommandException("EPPSession() Unable to get connection instance from factory: " + ex);
        }
        cat.debug((Object)"getConnection(): exit");
        return theConnection;
    }

    protected void initStreams() throws EPPCommandException {
        try {
            this.myOutputStream = new BufferedOutputStream(this.myConnection.getOutputStream(), 20480);
            this.myInputStream = this.myConnection.getInputStream();
        }
        catch (EPPConException ex) {
            cat.error((Object)("EPPSession() Unable to get streams from connection: " + ex));
            throw new EPPCommandException("EPPSession() Unable to get streams from connection: " + ex);
        }
        this.myXMLStream = new EPPXMLStream("EPP_XML_PARSER_POOL");
    }

    protected void login() throws EPPCommandException {
        cat.debug((Object)"login(): enter");
        Document myDoc = null;
        EPPGreeting myGreeting = null;
        EPPLoginCmd myCommand = null;
        myDoc = this.recDocument();
        try {
            myGreeting = this.myCodec.decodeGreeting(myDoc);
            cat.debug((Object)("the greeting received is [" + myGreeting + "]"));
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("login(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Login() decode [EppDecodeException]: " + myException.getMessage());
        }
        catch (NullPointerException myException) {
            cat.error((Object)("login(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Login () decode [Null Pointer Exception] : " + myException.getMessage());
        }
        myCommand = this.myNewPassword == null ? new EPPLoginCmd(this.myTransId, this.myClientID, this.myPassword) : new EPPLoginCmd(this.myTransId, this.myClientID, this.myPassword, this.myNewPassword);
        if (this.myVersion != null) {
            myCommand.setVersion(this.myVersion);
        }
        if (this.myLanguage != null) {
            myCommand.setLang(this.myLanguage);
        }
        myCommand.mergeServicesAndExtensionServices(myGreeting);
        if (this.myExtensionServices != null) {
            myCommand.setExtensions(this.myExtensionServices);
        }
        if (this.myServices != null) {
            myCommand.setServices(this.myServices);
        }
        if (cat.isDebugEnabled() && !myCommand.isValidServices(myGreeting)) {
            cat.debug((Object)("Login services does not match the greeting services, greeting = [" + myGreeting + "], login = [" + myCommand + "]"));
        }
        try {
            myDoc = this.myCodec.encode(myCommand);
        }
        catch (EPPEncodeException myException) {
            cat.error((Object)("login(): Exception encoding login command: " + myException));
            throw new EPPCommandException("EPPSession.login() decode : " + myException.getMessage());
        }
        this.sendDocument(myDoc);
        myDoc = this.recDocument();
        try {
            this.myResponse = this.myCodec.decodeResponse(myDoc);
            cat.debug((Object)("the response is [" + this.myResponse + "]"));
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("login(): Exception decoding login response: " + myException));
            throw new EPPCommandException("EPPSession.initialize() decode : " + myException.getMessage());
        }
        if (!this.myResponse.isSuccess()) {
            cat.error((Object)("login(): Login failure response: " + this.myResponse));
            throw new EPPCommandException("EPPSession.login() : Error in response from Server ", this.myResponse);
        }
        this.validateClientTransId(myCommand, this.myResponse);
        this.myTransId = null;
        cat.debug((Object)"login(): exit");
    }

    public EPPGreeting hello() throws EPPCommandException {
        cat.debug((Object)"hello(): enter");
        Document myDoc = null;
        EPPHello myHello = null;
        EPPGreeting myGreeting = null;
        myHello = new EPPHello();
        try {
            myDoc = this.myCodec.encode(myHello);
        }
        catch (EPPEncodeException myException) {
            throw new EPPCommandException("EPPSession.Hello() decode : " + myException.getMessage());
        }
        this.sendDocument(myDoc);
        myDoc = this.recDocument();
        try {
            myGreeting = this.myCodec.decodeGreeting(myDoc);
            cat.debug((Object)("hello greeting response = [" + myGreeting + "]"));
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("hello(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Hello() decode [EppDecodeException]: " + myException.getMessage());
        }
        catch (NullPointerException myException) {
            cat.error((Object)("hello(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Hello() decode [Null Pointer Exception] : " + myException.getMessage());
        }
        cat.debug((Object)"hello(): exit");
        return myGreeting;
    }

    public EPPResponse sendPoll() throws EPPCommandException {
        cat.debug((Object)"sendPoll(): enter");
        EPPPollCmd myCommand = new EPPPollCmd(this.myTransId, this.myPollOp);
        if (this.myPollOp.equals(OP_ACK)) {
            myCommand.setMsgID(this.msgID);
        }
        cat.debug((Object)"sendPoll(): exit");
        return this.processDocument(myCommand, EPPResponse.class);
    }

    protected void logout() throws EPPCommandException {
        cat.debug((Object)"logout(): enter");
        Document myDoc = null;
        EPPLogoutCmd myCommand = null;
        myCommand = new EPPLogoutCmd(this.myTransId);
        try {
            myDoc = this.myCodec.encode(myCommand);
        }
        catch (EPPEncodeException myException) {
            cat.error((Object)("logout(): Exception encoding command: " + myException));
            throw new EPPCommandException("EPPSession.logout() decode : " + myException.getMessage());
        }
        try {
            this.myXMLStream.write(myDoc, this.myOutputStream);
        }
        catch (Exception myException) {
            cat.error((Object)("logout(): Exception writing to stream: " + myException));
            throw new EPPCommandException("EPPSession.logout() : " + myException.getMessage());
        }
        try {
            myDoc = this.myXMLStream.read(this.myInputStream);
        }
        catch (Exception myException) {
            cat.error((Object)("logout(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.logout() : " + myException.getMessage());
        }
        try {
            this.myResponse = this.myCodec.decodeResponse(myDoc);
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("logout(): Exception decoding response: " + myException));
            throw new EPPCommandException("EPPSession.logout() decode : " + myException.getMessage());
        }
        if (!this.myResponse.isSuccess()) {
            cat.error((Object)("logout(): Logout failed due to server error: " + this.myResponse));
            throw new EPPCommandException("EPPSession.logout() : Error in response from Server ", this.myResponse);
        }
        this.validateClientTransId(myCommand, this.myResponse);
        cat.debug((Object)"logout(): exit");
    }

    public void validateClientTransId(EPPCommand myCommand, EPPResponse myResponse) throws EPPCommandException {
        String theRespTransId = myResponse.getTransId().getClientTransId();
        String theCmdTransId = myCommand.getTransId();
        if (theCmdTransId == null && theRespTransId == null) {
            return;
        }
        if (theCmdTransId == null || theRespTransId == null) {
            throw new EPPCommandException("null check, Response trans id of [" + theRespTransId + "] != Command trans id of [" + theCmdTransId + "]", myResponse);
        }
        if (theRespTransId.compareTo(theCmdTransId) != 0) {
            throw new EPPCommandException("Response trans id of [" + theRespTransId + "] != Command trans id of [" + theCmdTransId + "]", myResponse);
        }
    }

    Document recDocument() throws EPPCommandException {
        Document myDoc;
        try {
            myDoc = this.myXMLStream.read(this.myInputStream);
        }
        catch (EPPException myException) {
            cat.error((Object)("recDocument(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.recDocument : " + myException.getMessage());
        }
        catch (IOException myException) {
            cat.error((Object)("recDocument(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.recDocument : " + myException.getMessage());
        }
        return myDoc;
    }

    void sendDocument(Document newDoc) throws EPPCommandException {
        try {
            this.myXMLStream.write(newDoc, this.myOutputStream);
        }
        catch (EPPException myException) {
            cat.error((Object)("sendDocument(): Exception writing to stream: " + myException));
            throw new EPPCommandException("EPPSession.sendDocument() : " + myException.getMessage());
        }
    }

    public EPPResponse processDocument(EPPCommand aCommand) throws EPPCommandException {
        return this.processDocument(aCommand, null);
    }

    public EPPResponse readResponse() throws EPPCommandException {
        this.myResponse = null;
        Document theDoc = null;
        theDoc = this.recDocument();
        try {
            this.myResponse = this.myCodec.decodeResponse(theDoc);
        }
        catch (EPPDecodeException myException) {
            throw new EPPCommandException("EPPSession.readResponse: On Response " + myException.getMessage());
        }
        return this.myResponse;
    }

    public EPPResponse processDocument(EPPCommand aCommand, Class aExpectedResponse) throws EPPCommandException {
        Document theDoc = null;
        try {
            theDoc = this.myCodec.encode(aCommand);
        }
        catch (Exception myException) {
            throw new EPPCommandException("EPPSession.processDocument: On Command " + myException.getMessage());
        }
        this.sendDocument(theDoc);
        if (this.mode == 1) {
            return null;
        }
        EPPResponse theResponse = this.readResponse();
        if (!theResponse.isSuccess()) {
            throw new EPPCommandException("EPPSession.processDocument() : Error in response from Server", this.myResponse);
        }
        if (aExpectedResponse != null && !aExpectedResponse.isInstance(theResponse)) {
            throw new EPPCommandException("Unexpected response type of " + theResponse.getClass().getName() + ", expecting " + aExpectedResponse);
        }
        this.validateClientTransId(aCommand, theResponse);
        return theResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession() throws EPPCommandException {
        cat.debug((Object)"endSession(): enter");
        try {
            this.logout();
        }
        finally {
            try {
                this.endConnection();
            }
            catch (Exception exception) {}
        }
        cat.debug((Object)"endSession(): exit");
    }

    public void endConnection() throws EPPCommandException {
        cat.debug((Object)"endConnection(): enter");
        try {
            if (this.myInputStream != null) {
                this.myInputStream.close();
                this.myInputStream = null;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.myOutputStream != null) {
                this.myOutputStream.close();
                this.myOutputStream = null;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.myConnection != null) {
                this.myConnection.close();
                this.myConnection = null;
            }
        }
        catch (Exception ex) {
            cat.error((Object)("endConnection(): Exception closing connection: " + ex));
            throw new EPPCommandException("EPPApplication.CloseConnection() : " + ex.getMessage());
        }
        cat.debug((Object)"endConnection(): exit");
    }

    public void initSession() throws EPPCommandException {
        cat.debug((Object)"initSession(): enter");
        if (this.myClientID == null) {
            throw new EPPCommandException("EPPSession.initSession Login requires ClientID");
        }
        if (this.myPassword == null) {
            throw new EPPCommandException("EPPSession.initSession Login requires Password");
        }
        this.login();
        cat.debug((Object)"initSession(): exit");
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String newVersion) {
        this.myVersion = newVersion;
    }

    public String setLang() {
        return this.myLanguage;
    }

    public void setLang(String newLanguage) {
        this.myLanguage = newLanguage;
    }

    public String getTransId() {
        return this.myTransId;
    }

    public void setTransId(String newTransId) {
        this.myTransId = newTransId;
    }

    public EPPResponse getResponse() {
        return this.myResponse;
    }

    public InputStream getInputStream() {
        return this.myInputStream;
    }

    public void setInputStream(InputStream newInput) {
        this.myInputStream = newInput;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public EPPClientCon getClientCon() {
        return this.myConnection;
    }

    public void setOutputStream(OutputStream newOutput) {
        this.myOutputStream = newOutput;
    }

    public String getClientID() {
        return this.myClientID;
    }

    public void setClientID(String newClientID) {
        this.myClientID = newClientID;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(String newPassword) {
        this.myPassword = newPassword;
    }

    public String getnewPassword() {
        return this.myNewPassword;
    }

    public void setNewPassword(String newPassword) {
        this.myNewPassword = newPassword;
    }

    public void setServices(String[] newServiceNS) throws EPPCommandException {
        Vector<EPPService> theServices = new Vector<EPPService>();
        Vector factoryServices = EPPFactory.getInstance().getServices();
        for (int newService = 0; newService < newServiceNS.length; ++newService) {
            boolean found = false;
            for (int facService = 0; !found && facService < factoryServices.size(); ++facService) {
                EPPService currFacService = (EPPService)factoryServices.elementAt(facService);
                if (!newServiceNS[newService].equals(currFacService.getNamespaceURI())) continue;
                theServices.addElement(currFacService);
                found = true;
            }
            if (found) continue;
            throw new EPPCommandException("EppSession.setServices() : Invalid service: " + newServiceNS[newService] + " specified");
        }
        this.myServices = theServices;
    }

    public void setExtensions(Vector ProtocolExtensions, Vector CommandResponseExtensions) throws EPPCommandException {
        Vector<EPPService> theExtensions = new Vector<EPPService>();
        Vector factoryExtensions = EPPFactory.getInstance().getExtensions();
        Vector<String> extensionsVector = new Vector<String>();
        if (ProtocolExtensions != null && ProtocolExtensions.elements().hasMoreElements()) {
            for (int i = 0; i < ProtocolExtensions.size(); ++i) {
                extensionsVector.addElement((String)ProtocolExtensions.elementAt(i));
            }
        }
        if (CommandResponseExtensions != null && CommandResponseExtensions.elements().hasMoreElements()) {
            for (int j = 0; j < CommandResponseExtensions.size(); ++j) {
                extensionsVector.addElement((String)CommandResponseExtensions.elementAt(j));
            }
        }
        if (extensionsVector != null && extensionsVector.elements().hasMoreElements()) {
            for (int newExtension = 0; newExtension < extensionsVector.size(); ++newExtension) {
                boolean found = false;
                for (int facExtension = 0; !found && facExtension < factoryExtensions.size(); ++facExtension) {
                    EPPService currFacExtension = (EPPService)factoryExtensions.elementAt(facExtension);
                    String extensionNameSpace = (String)extensionsVector.elementAt(facExtension);
                    if (!extensionNameSpace.equals(currFacExtension.getNamespaceURI())) continue;
                    theExtensions.addElement(currFacExtension);
                    found = true;
                }
                if (found) continue;
                throw new EPPCommandException("EppSession.setExtenisons() : Invalid extension: " + (String)extensionsVector.elementAt(newExtension) + " specified");
            }
        }
        this.myExtensionServices = theExtensions;
        for (int k = 0; k < this.myExtensionServices.size(); ++k) {
            EPPService currFacService = (EPPService)this.myExtensionServices.elementAt(k);
        }
    }

    public void setPollOp(String aOp) {
        this.myPollOp = aOp;
    }

    public String getPollOp() {
        return this.myPollOp;
    }

    public String getStatusTransId() {
        return this.statusTransId;
    }

    public void setStatusTransId(String aStatusTrans) {
        this.statusTransId = aStatusTrans;
    }

    public String getStatusCommandType() {
        return this.statusCommandType;
    }

    public void setStatusCommandType(String aStatusCommandType) {
        this.statusCommandType = aStatusCommandType;
    }

    public String getMsgID() {
        return this.msgID;
    }

    public void setMsgID(String aMsgID) {
        this.msgID = aMsgID;
    }

    public int getMode() {
        return this.mode;
    }

    public int setMode(int aMode) {
        if (this.isModeSupported(aMode)) {
            int thePrevMode = this.mode;
            this.mode = aMode;
            return thePrevMode;
        }
        cat.error((Object)("EPPSession.setMode(): Mode " + aMode + " NOT supported, current mode " + this.mode + " unchanged"));
        return this.mode;
    }

    public boolean isModeSupported(int aMode) {
        return aMode == 0 || aMode == 1;
    }
}

