/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.codestudio.util.GenericPool;
import com.codestudio.util.GenericPoolManager;
import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPByteArrayAssembler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPXMLByteArray;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPXMLByteArrayAssembler
implements EPPByteArrayAssembler {
    private static Logger LOG = Logger.getLogger((String)EPPXMLByteArrayAssembler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static boolean _parserInitialized = false;
    private EPPCodec codec = EPPCodec.getInstance();

    public static byte[] toBytes(int aInteger) {
        byte[] bytes = new byte[]{(byte)(aInteger >>> 24 & 0xFF), (byte)(aInteger >>> 16 & 0xFF), (byte)(aInteger >>> 8 & 0xFF), (byte)(aInteger >>> 0 & 0xFF)};
        return bytes;
    }

    public EPPXMLByteArrayAssembler() {
        this.initParserPool();
    }

    private void initParserPool() {
        if (!_parserInitialized) {
            LOG.debug((Object)"EPPXMLByteArray.initParserPool(): Creating parser pool");
            GenericPoolMetaData parserMeta = new GenericPoolMetaData();
            parserMeta.setName("EPP_XML_PARSER_POOL");
            parserMeta.setObjectType("com.verisign.epp.util.EPPSchemaCachingParser");
            parserMeta.setInitialObjects(EPPEnv.getServerParserInitObjs());
            parserMeta.setMinimumSize(EPPEnv.getServerParserMinSize());
            parserMeta.setMaximumSize(EPPEnv.getServerParserMaxSize());
            parserMeta.setMaximumSoft(EPPEnv.getServerParserMaxSoft());
            parserMeta.setObjectTimeout(EPPEnv.getServerParserObjTimeout());
            parserMeta.setUserTimeout(EPPEnv.getServerParserUserTimeout());
            parserMeta.setSkimmerFrequency(EPPEnv.getServerParserSkimmerFreq());
            parserMeta.setShrinkBy(EPPEnv.getServerParserShrinkBy());
            parserMeta.setLogFile(EPPEnv.getServerParserLogFile());
            parserMeta.setDebugging(EPPEnv.getServerParserDebug());
            GenericPool parserPool = new GenericPool((PoolMetaData)parserMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_PARSER_POOL", (ObjectPool)parserPool);
            LOG.debug((Object)"EPPXMLByteArray.initParserPool(): Creating transformer pool");
            GenericPoolMetaData transformerMeta = new GenericPoolMetaData();
            transformerMeta.setName("EPP_XML_TRANSFORMER_POOL");
            transformerMeta.setObjectType("com.verisign.epp.util.EPPTransformer");
            transformerMeta.setInitialObjects(EPPEnv.getServerParserInitObjs());
            transformerMeta.setMinimumSize(EPPEnv.getServerParserMinSize());
            transformerMeta.setMaximumSize(EPPEnv.getServerParserMaxSize());
            transformerMeta.setMaximumSoft(EPPEnv.getServerParserMaxSoft());
            transformerMeta.setObjectTimeout(EPPEnv.getServerParserObjTimeout());
            transformerMeta.setUserTimeout(EPPEnv.getServerParserUserTimeout());
            transformerMeta.setSkimmerFrequency(EPPEnv.getServerParserSkimmerFreq());
            transformerMeta.setShrinkBy(EPPEnv.getServerParserShrinkBy());
            transformerMeta.setLogFile(EPPEnv.getServerParserLogFile());
            transformerMeta.setDebugging(EPPEnv.getServerParserDebug());
            GenericPool transformerPool = new GenericPool((PoolMetaData)transformerMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_TRANSFORMER_POOL", (ObjectPool)transformerPool);
            _parserInitialized = true;
        }
    }

    public EPPEvent decode(byte[] aBytes, Object aData) throws EPPAssemblerException {
        LOG.debug((Object)"decode(): Enter");
        EPPMessage message = null;
        try {
            EPPXMLByteArray xmlByteArray = new EPPXMLByteArray("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
            Document domDocument = xmlByteArray.decode(aBytes);
            message = this.codec.decode(domDocument);
        }
        catch (EPPComponentNotFoundException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            switch (e.getKind()) {
                case 1: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.COMMANDNOTFOUND);
                }
                case 3: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.EXTENSIONNOTFOUND);
                }
                case 2: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.RESPONSENOTFOUND);
                }
            }
        }
        catch (EPPDecodeException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPAssemblerException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            throw e;
        }
        catch (EPPException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.XML);
        }
        catch (InterruptedIOException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.INTRUPTEDIO);
        }
        catch (IOException e) {
            LOG.debug((Object)"decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.CLOSECON);
        }
        LOG.debug((Object)"decode(): Return");
        return new EPPEvent(message);
    }

    public byte[] encode(EPPEventResponse aResponse, Object aData) throws EPPAssemblerException {
        LOG.debug((Object)"encode(): Enter");
        byte[] responseBytes = null;
        try {
            EPPMessage response = aResponse.getResponse();
            Document domDocument = this.codec.encode(response);
            EPPXMLByteArray xmlByteArray = new EPPXMLByteArray("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
            responseBytes = xmlByteArray.encode(domDocument);
        }
        catch (EPPEncodeException e) {
            LOG.debug((Object)"encode()", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPException e) {
            LOG.debug((Object)"encode()", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.FATAL);
        }
        LOG.debug((Object)("EPP Packet Header = " + (responseBytes.length + 4)));
        byte[] eppPacketHeader = EPPXMLByteArrayAssembler.toBytes(responseBytes.length + 4);
        byte[] eppPacket = new byte[responseBytes.length + 4];
        System.arraycopy(eppPacketHeader, 0, eppPacket, 0, 4);
        System.arraycopy(responseBytes, 0, eppPacket, 4, responseBytes.length);
        LOG.debug((Object)"encode(): Return");
        return eppPacket;
    }
}

