/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;

public abstract class EPPGenHandler
implements EPPEventHandler {
    private static final String NS = "urn:ietf:params:xml:ns:epp-1.0";

    public final String getNamespace() {
        return NS;
    }

    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPLoginCmd) {
            response = this.doLogin(aEvent, aData);
        } else if (message instanceof EPPLogoutCmd) {
            response = this.doLogout(aEvent, aData);
        } else if (message instanceof EPPPollCmd) {
            response = this.doPoll(aEvent, aData);
        } else if (message instanceof EPPHello) {
            response = this.doHello(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPGenHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doLogin(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doLogout(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doPoll(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHello(EPPEvent var1, Object var2);
}

