/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPConnectionHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.util.EPPCatFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPDispatcher {
    private static final EPPDispatcher _instance = new EPPDispatcher();
    private static Logger cat = Logger.getLogger((String)EPPDispatcher.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private Hashtable eventHandlers = new Hashtable();
    private EPPAssembler theAssembler;
    private EPPConnectionHandler connectionHandler;

    private EPPDispatcher() {
    }

    public static EPPDispatcher getInstance() {
        return _instance;
    }

    public void processConnection(InputStream aInputStream, OutputStream aOutputStream, Object aData) {
        cat.debug((Object)"processConnection(InputStream, OutputStream, Object): Enter");
        try {
            EPPEventResponse greeting = this.connectionHandler.handleConnection(aData);
            this.theAssembler.toStream(greeting, aOutputStream, aData);
        }
        catch (EPPAssemblerException e) {
            cat.error((Object)"processConnection(InputStream, OutputStream, Object)", (Throwable)e);
        }
        catch (NullPointerException e) {
            cat.error((Object)"processConnection(InputStream, OutputStream, Object)", (Throwable)e);
        }
        cat.debug((Object)"processConnection(InputStream, OutputStream, Object): Return");
    }

    public void setAssembler(EPPAssembler aAssembler) {
        this.theAssembler = aAssembler;
    }

    public void processMessage(InputStream aInputStream, OutputStream aOutputStream, Object aData) throws EPPEventException, EPPAssemblerException {
        cat.debug((Object)"processMessage(InputStream, OutputStream, Object): Enter");
        if (this.theAssembler == null) {
            throw new EPPAssemblerException("No Assembler registered withEPPDispatcher", EPPAssemblerException.FATAL);
        }
        EPPEvent event = this.theAssembler.toEvent(aInputStream, aData);
        EPPMessage message = event.getMessage();
        String namespace = message.getNamespace();
        cat.debug((Object)("Sending event for Namespace " + namespace));
        EPPEventHandler handler = (EPPEventHandler)this.eventHandlers.get(namespace);
        if (handler == null) {
            cat.error((Object)("processMessage(InputStream, OutputStream, Object): Handler not found for Namespace " + namespace));
            throw new EPPEventException("Handler not found for Namespace " + namespace);
        }
        EPPEventResponse eventResponse = handler.handleEvent(event, aData);
        if (eventResponse != null && eventResponse.getResponse() != null) {
            cat.debug((Object)"processMessage(InputStream, OutputStream, Object): Sending response to Assembler");
            this.theAssembler.toStream(eventResponse, aOutputStream, aData);
        } else {
            cat.debug((Object)"processMessage(InputStream, OutputStream, Object): No response to send to Assembler");
        }
        cat.debug((Object)"processMessage(InputStream, OutputStream, Object): Return");
    }

    public void registerHandler(EPPEventHandler aHandler) {
        this.eventHandlers.put(aHandler.getNamespace(), aHandler);
    }

    public void registerConnectionHandler(EPPConnectionHandler aConnectionHandler) {
        this.connectionHandler = aConnectionHandler;
    }

    public void send(EPPMessage aMessage, OutputStream aOutputStream) throws EPPAssemblerException {
        this.theAssembler.toStream(new EPPEventResponse(aMessage), aOutputStream, null);
    }

    public void send(EPPMessage aMessage, OutputStream aOutputStream, Object aData) throws EPPAssemblerException {
        this.theAssembler.toStream(new EPPEventResponse(aMessage), aOutputStream, aData);
    }
}

