/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whowas;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPWhoWasRecord
implements EPPCodecComponent {
    private Date transactionDate = null;
    private String name = null;
    private String newName = null;
    private String roid = null;
    private String operation = null;
    private String clientID = null;
    private String clientName = null;
    private static Logger cat = Logger.getLogger((String)EPPWhoWasRecord.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPWhoWasRecord() {
    }

    public EPPWhoWasRecord(String aName, String aRoid, Date aTransactionDate, String aOperation, String aClientID, String aClientName) {
        this(aName, aRoid, null, aTransactionDate, aOperation, aClientID, aClientName);
    }

    public EPPWhoWasRecord(String aName, String aRoid, String aNewName, Date aTransactionDate, String aOperation, String aClientID, String aClientName) {
        this.name = aName;
        this.roid = aRoid;
        this.newName = aNewName;
        this.transactionDate = aTransactionDate;
        this.operation = aOperation;
        this.clientID = aClientID;
        this.clientName = aClientName;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.transactionDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:date");
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:name");
        this.newName = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:newName");
        this.roid = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:roid");
        this.operation = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:op");
        this.clientID = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:clID");
        this.clientName = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:clName");
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null && this.roid == null) {
            throw new EPPEncodeException("EPPWhoWasRecord name or roid attributes must be set");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/whowas-1.0", "whowas:rec");
        EPPUtil.encodeTimeInstant(aDocument, root, this.transactionDate, "http://www.verisign.com/epp/whowas-1.0", "whowas:date");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/whowas-1.0", "whowas:name");
        EPPUtil.encodeString(aDocument, root, this.newName, "http://www.verisign.com/epp/whowas-1.0", "whowas:newName");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.verisign.com/epp/whowas-1.0", "whowas:roid");
        EPPUtil.encodeString(aDocument, root, this.operation, "http://www.verisign.com/epp/whowas-1.0", "whowas:op");
        EPPUtil.encodeString(aDocument, root, this.clientID, "http://www.verisign.com/epp/whowas-1.0", "whowas:clID");
        EPPUtil.encodeString(aDocument, root, this.clientName, "http://www.verisign.com/epp/whowas-1.0", "whowas:clName");
        return root;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPWhoWasRecord clone = (EPPWhoWasRecord)super.clone();
        clone.name = this.name;
        clone.roid = this.roid;
        clone.newName = this.newName;
        clone.transactionDate = this.transactionDate;
        clone.operation = this.operation;
        clone.clientID = this.clientID;
        clone.clientName = this.clientName;
        return clone;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPWhoWasRecord other = (EPPWhoWasRecord)o;
            if (!EqualityUtil.equals(this.transactionDate, other.transactionDate)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): transactionDate not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.name, other.name)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): name not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.newName, other.newName)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): newName not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.roid, other.roid)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): roid not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.operation, other.operation)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): operation not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.clientID, other.clientID)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): clientID not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.clientName, other.clientName)) {
                cat.error((Object)"EPPWhoWasRecord.equals(): clientName not equal");
                return false;
            }
            return true;
        }
        cat.error((Object)"EPPWhoWasRecord.equals(): not EPPDomainInfoResp instance");
        return false;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date aTransactionDate) {
        this.transactionDate = aTransactionDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String aNewName) {
        this.newName = aNewName;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String aOperation) {
        this.operation = aOperation;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String aClientID) {
        this.clientID = aClientID;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String aClientName) {
        this.clientName = aClientName;
    }
}

