/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whowas;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.whowas.EPPWhoWasRecord;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPWhoWasHistory
implements EPPCodecComponent {
    private static final Logger cat = Logger.getLogger((String)EPPWhoWasHistory.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private List records = null;

    public void decode(Element aElement) throws EPPDecodeException {
        this.records = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:rec", EPPWhoWasRecord.class);
        if (this.records == null || this.records.isEmpty()) {
            throw new EPPDecodeException("EPPWhoWasHistory has null records list");
        }
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.records == null || this.records.isEmpty()) {
            throw new EPPEncodeException("EPPWhoWasHistory has null or empty records list");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/whowas-1.0", "whowas:history");
        EPPUtil.encodeCompList(aDocument, root, this.records);
        return root;
    }

    public void addRecord(EPPWhoWasRecord aEPPWhoWasRec) {
        if (aEPPWhoWasRec == null) {
            throw new IllegalArgumentException("Cannot add a null EPPWhoWasRecord");
        }
        if (this.records == null) {
            this.records = new ArrayList();
        }
        this.records.add(aEPPWhoWasRec);
    }

    public Object clone() throws CloneNotSupportedException {
        EPPWhoWasHistory clone = (EPPWhoWasHistory)super.clone();
        if (this.records != null) {
            clone.records = new ArrayList();
            for (int i = 0; i < this.records.size(); ++i) {
                EPPWhoWasRecord record = (EPPWhoWasRecord)this.records.get(i);
                clone.addRecord((EPPWhoWasRecord)record.clone());
            }
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPWhoWasHistory other = (EPPWhoWasHistory)o;
            if (!EPPUtil.equalLists(this.records, other.records)) {
                cat.error((Object)"EPPWhoWasHistory.equals: records are not equal");
                return false;
            }
            return true;
        }
        cat.error((Object)"EPPWhoWasHistory.equals(): not EPPWhoWasHistory instance");
        return false;
    }

    public List getRecords() {
        return this.records;
    }

    public void setRecords(List aRecords) {
        this.records = aRecords;
    }
}

