/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion.util;

import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.suggestion.EPPSuggestionAction;
import com.verisign.epp.codec.suggestion.EPPSuggestionAddress;
import com.verisign.epp.codec.suggestion.EPPSuggestionAnswer;
import com.verisign.epp.codec.suggestion.EPPSuggestionCell;
import com.verisign.epp.codec.suggestion.EPPSuggestionCoordinates;
import com.verisign.epp.codec.suggestion.EPPSuggestionFilter;
import com.verisign.epp.codec.suggestion.EPPSuggestionGeo;
import com.verisign.epp.codec.suggestion.EPPSuggestionGrid;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoCmd;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoResp;
import com.verisign.epp.codec.suggestion.EPPSuggestionRecord;
import com.verisign.epp.codec.suggestion.EPPSuggestionRelated;
import com.verisign.epp.codec.suggestion.EPPSuggestionRow;
import com.verisign.epp.codec.suggestion.EPPSuggestionTable;
import com.verisign.epp.codec.suggestion.EPPSuggestionTld;
import com.verisign.epp.codec.suggestion.EPPSuggestionToken;
import com.verisign.epp.codec.suggestion.util.ActionEnum;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.StatusEnum;
import com.verisign.epp.codec.suggestion.util.TldEnum;
import com.verisign.epp.codec.suggestion.util.WeightEnum;
import java.util.Random;

public class RandomHelper {
    private static Random random = new Random();

    public static double get() {
        return random.nextDouble();
    }

    public static int getInt() {
        return random.nextInt();
    }

    public static int getInt(int aMaxValue) {
        return (int)(random.nextDouble() * (double)aMaxValue);
    }

    public static int getInt(int n, int r) {
        return (int)(random.nextDouble() * (double)r + (double)n);
    }

    public static long getLong() {
        return random.nextLong();
    }

    public static long getLong(long aMaxValue) {
        return (long)(random.nextDouble() * (double)aMaxValue);
    }

    public static long getLong(long n, long r) {
        return (long)(random.nextDouble() * (double)r + (double)n);
    }

    public static EPPSuggestionInfoCmd getCommand() throws InvalidValueException {
        EPPSuggestionInfoCmd cmd = new EPPSuggestionInfoCmd("51364-CLI");
        cmd.setKey("alphabravocharlie.com");
        cmd.setLanguage("ENG");
        if (RandomHelper.p(0.9)) {
            if (RandomHelper.p(0.2)) {
                cmd.setFilterId(RandomHelper.getLong(1000000L));
            } else {
                EPPSuggestionFilter filter = new EPPSuggestionFilter();
                if (RandomHelper.p(0.9)) {
                    filter.setContentFilter(RandomHelper.p(0.5));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setCustomFilter(RandomHelper.p(0.5));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setForSale(WeightEnum.getRandomString());
                }
                if (RandomHelper.p(0.9)) {
                    filter.setMaxLength((short)RandomHelper.getInt(20, 30));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setMaxResults((short)RandomHelper.getInt(10, 20));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setUseHyphens(RandomHelper.p(0.5));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setUseNumbers(RandomHelper.p(0.5));
                }
                if (RandomHelper.p(0.9)) {
                    filter.setUseIdns(RandomHelper.p(0.5));
                }
                if (RandomHelper.p(0.9)) {
                    if (RandomHelper.p(0.5)) {
                        filter.setTableView();
                    } else {
                        filter.setGridView();
                    }
                }
                if (RandomHelper.p(0.9)) {
                    EPPSuggestionGeo geo = new EPPSuggestionGeo();
                    if (RandomHelper.p(0.5)) {
                        geo.setCoordinates(new EPPSuggestionCoordinates((double)RandomHelper.getInt(20000, 30000) / 10000.0, (double)RandomHelper.getInt(20000, 30000) / 10000.0));
                    } else {
                        geo.setAddr(new EPPSuggestionAddress("123.0.0.1"));
                    }
                    filter.setGeo(geo);
                }
                String name = null;
                String weight = null;
                double d = 0.8;
                while (RandomHelper.p(d)) {
                    name = RandomHelper.p(0.1) ? "DUMMY" : ActionEnum.getRandomString();
                    weight = WeightEnum.getRandomString();
                    filter.addAction(new EPPSuggestionAction(name, weight));
                    d -= 0.2;
                }
                d = 0.8;
                while (RandomHelper.p(d)) {
                    name = RandomHelper.p(0.1) ? "DUMMY" : TldEnum.getRandomString();
                    filter.addTld(new EPPSuggestionTld(name));
                    d -= 0.2;
                }
                cmd.setFilter(filter);
            }
        }
        return cmd;
    }

    public static EPPSuggestionInfoResp getResponse(String aClientTransId) throws InvalidValueException {
        EPPSuggestionAnswer answer = null;
        EPPTransId aTransId = new EPPTransId(aClientTransId, "SRV-43659");
        EPPSuggestionInfoResp theResponse = new EPPSuggestionInfoResp(aTransId);
        theResponse.setKey("AlphaBravoCharlie.com");
        theResponse.setLanguage("ENG");
        if (RandomHelper.p(0.75)) {
            String[] TOKEN = new String[]{"Alpha", "Bravo", "Charlie", "Delta", "Echo"};
            int i = 0;
            double d = 1.0;
            while (RandomHelper.p(d)) {
                String tokenName = TOKEN[i++];
                EPPSuggestionToken token = new EPPSuggestionToken(tokenName);
                int j = 0;
                double d2 = 0.9;
                while (RandomHelper.p(d2)) {
                    token.addRelated(new EPPSuggestionRelated(tokenName + j++));
                    d2 -= 0.2;
                }
                theResponse.addToken(token);
                d -= 0.2;
            }
        }
        String[] NAME = new String[]{"AlphaBravoCharlie1", "AlphaBravoCharlie2", "AlphaBravoCharlie3", "AlphaBravoCharlie4", "AlphaBravoCharlie5", "AlphaBravoCharlie6"};
        String[] TLD = new String[]{"com", "net", "cc", "tv", "DUMMY"};
        if (RandomHelper.p(0.9)) {
            answer = new EPPSuggestionAnswer();
            if (RandomHelper.p(0.5)) {
                EPPSuggestionGrid grid = new EPPSuggestionGrid();
                int i = RandomHelper.getInt(NAME.length);
                double d = 0.9;
                while (RandomHelper.p(d)) {
                    EPPSuggestionRecord record = new EPPSuggestionRecord(NAME[i++]);
                    if (RandomHelper.p(0.5)) {
                        record.setSource("dummy");
                    }
                    if (RandomHelper.p(0.5)) {
                        record.setMoreLikeThis("http://dummy.com");
                    }
                    if (RandomHelper.p(0.5)) {
                        record.setPpcValue(RandomHelper.getInt());
                    }
                    int j = RandomHelper.getInt(TLD.length);
                    double d2 = 0.9;
                    short score = 1000;
                    while (RandomHelper.p(d2)) {
                        record.addCell(new EPPSuggestionCell(TLD[j++], score, StatusEnum.getRandomString()));
                        j %= TLD.length;
                        d2 -= 0.2;
                        score = (short)(score - RandomHelper.getInt(10, 20));
                    }
                    grid.addRecord(record);
                    i %= NAME.length;
                    d -= 0.2;
                }
                answer.setGrid(grid);
            } else {
                EPPSuggestionTable table = new EPPSuggestionTable();
                int i = RandomHelper.getInt(NAME.length);
                int j = RandomHelper.getInt(TLD.length);
                double d = 0.9;
                short score = 1000;
                while (RandomHelper.p(d)) {
                    EPPSuggestionRow row = RandomHelper.p(0.5) ? new EPPSuggestionRow(NAME[i++] + "." + TLD[j++], score, StatusEnum.getRandomString()) : new EPPSuggestionRow(NAME[i++] + "." + TLD[j++], score, StatusEnum.getRandomString(), "dummy", "http://dummy.com", new Integer(RandomHelper.getInt()));
                    table.addRow(row);
                    i %= NAME.length;
                    j %= TLD.length;
                    score = (short)(score - RandomHelper.getInt(10, 20));
                    d -= 0.2;
                }
                answer.setTable(table);
            }
            theResponse.setAnswer(answer);
        }
        theResponse.setResult(1000);
        return theResponse;
    }

    public static EPPSuggestionInfoResp getEmptyTableResponse(String aClientTransId) {
        EPPTransId aTransId = new EPPTransId(aClientTransId, "SRV-43659");
        EPPSuggestionInfoResp theResponse = new EPPSuggestionInfoResp(aTransId);
        theResponse.setKey("Empty Table");
        theResponse.setLanguage("ENG");
        EPPSuggestionAnswer answer = new EPPSuggestionAnswer();
        answer.setTable(new EPPSuggestionTable());
        theResponse.setAnswer(answer);
        theResponse.setResult(1000);
        return theResponse;
    }

    public static EPPSuggestionInfoResp getEmptyGridResponse(String aClientTransId) {
        EPPTransId aTransId = new EPPTransId(aClientTransId, "SRV-43659");
        EPPSuggestionInfoResp theResponse = new EPPSuggestionInfoResp(aTransId);
        theResponse.setKey("Empty Grid");
        EPPSuggestionAnswer answer = new EPPSuggestionAnswer();
        answer.setGrid(new EPPSuggestionGrid());
        theResponse.setAnswer(answer);
        theResponse.setResult(1000);
        return theResponse;
    }

    public static EPPSuggestionInfoResp getEmptyRecordResponse(String aClientTransId) throws InvalidValueException {
        EPPTransId aTransId = new EPPTransId(aClientTransId, "SRV-43659");
        EPPSuggestionInfoResp theResponse = new EPPSuggestionInfoResp(aTransId);
        theResponse.setKey("Empty Record");
        theResponse.setLanguage("ENG");
        EPPSuggestionAnswer answer = new EPPSuggestionAnswer();
        EPPSuggestionGrid grid = new EPPSuggestionGrid();
        grid.addRecord(new EPPSuggestionRecord("Empty-Record"));
        answer.setGrid(grid);
        theResponse.setAnswer(answer);
        theResponse.setResult(1000);
        return theResponse;
    }

    public static void reset() {
        random = new Random();
    }

    public static void reset(long aSeed) {
        random = new Random(aSeed);
        System.out.println("Random Helper seed: " + aSeed);
    }

    public static boolean p(double d) {
        return RandomHelper.get() < d;
    }
}

