/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionRow;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPSuggestionTable
implements EPPCodecComponent {
    private static final long serialVersionUID = 6847559284918162952L;
    static final String ELM_NAME = "suggestion:table";
    private List<EPPSuggestionRow> rows = null;

    public EPPSuggestionTable() {
    }

    public EPPSuggestionTable(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public List<EPPSuggestionRow> getRows() {
        return this.rows;
    }

    public void addRow(EPPSuggestionRow aRow) throws InvalidValueException {
        if (aRow == null) {
            throw new InvalidValueException((Object)"Cannot add a null Row");
        }
        if (this.rows == null) {
            this.resetRows();
        }
        this.rows.add(aRow);
    }

    public void resetRows() {
        this.rows = new ArrayList<EPPSuggestionRow>();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionTable)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        NodeList nodes = aElement.getChildNodes();
        Node node = null;
        this.resetRows();
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.rows.add(new EPPSuggestionRow((Element)node));
        }
        if (this.rows.size() == 0) {
            this.rows = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.rows != null) {
            EPPUtil.encodeCompList(aDocument, root, this.rows);
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionTable other = (EPPSuggestionTable)o;
            return EqualityUtil.equals(this.rows, other.rows);
        }
        return false;
    }
}

