/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionCell;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPSuggestionRecord
implements EPPCodecComponent {
    private static final long serialVersionUID = -2508113362329827161L;
    private static final String ATT_NAME = "name";
    private static final String ATT_SOURCE = "source";
    private static final String ATT_MORELIKETHIS = "morelikethis";
    private static final String ATT_UNAME = "uName";
    private static final String ATT_PPCVALUE = "ppcvalue";
    static final String ELM_NAME = "suggestion:record";
    private String name = null;
    private String source = null;
    private String moreLikeThis = null;
    private String uName = null;
    private Integer ppcValue = null;
    private List<EPPSuggestionCell> cells = null;

    public EPPSuggestionRecord() {
    }

    public EPPSuggestionRecord(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public EPPSuggestionRecord(String aName) {
        this();
        this.setName(aName);
    }

    public EPPSuggestionRecord(String aName, String aSource, String aMoreLikeThis, Integer aPpcValue) {
        this();
        this.setName(aName);
        this.setSource(aSource);
        this.setMoreLikeThis(aMoreLikeThis);
        this.setPpcValue(aPpcValue);
    }

    public EPPSuggestionRecord(String aName, String aSource, String aMoreLikeThis, Integer aPpcValue, String aUName) {
        this();
        this.setName(aName);
        this.setSource(aSource);
        this.setMoreLikeThis(aMoreLikeThis);
        this.setPpcValue(aPpcValue);
        this.setUName(aUName);
    }

    public void addCell(EPPSuggestionCell aCell) throws InvalidValueException {
        if (aCell == null) {
            throw new InvalidValueException((Object)"Cannot add a null Cell");
        }
        if (this.cells == null) {
            this.resetCells();
        }
        this.cells.add(aCell);
    }

    public List<EPPSuggestionCell> getCells() {
        return this.cells;
    }

    public String getMoreLikeThis() {
        return this.moreLikeThis;
    }

    public String getUName() {
        return this.uName;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPpcValue() {
        return this.ppcValue;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isSetMoreLikeThis() {
        return this.moreLikeThis != null && this.moreLikeThis.length() > 0;
    }

    public boolean isSetUName() {
        return this.uName != null && this.uName.length() > 0;
    }

    public boolean isSetSource() {
        return this.source != null && this.source.length() > 0;
    }

    public void resetCells() {
        this.cells = new ArrayList<EPPSuggestionCell>();
    }

    public void setMoreLikeThis(String aMoreLikeThis) {
        this.moreLikeThis = aMoreLikeThis;
    }

    public void setUName(String aUName) {
        this.uName = aUName;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setPpcValue(int aPpcValue) {
        this.ppcValue = new Integer(aPpcValue);
    }

    public void setPpcValue(Integer aPpcValue) {
        this.ppcValue = aPpcValue;
    }

    public void setPpcValue(String aPpcValue) {
        if (aPpcValue != null && aPpcValue.length() > 0) {
            this.ppcValue = new Integer(Integer.parseInt(aPpcValue));
        }
    }

    public void setSource(String aSource) {
        this.source = aSource;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionRecord)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String tmp;
        this.setName(aElement.getAttribute(ATT_NAME));
        if (this.name == null) {
            ExceptionUtil.missingDuringDecode(ATT_NAME);
        }
        if ((tmp = aElement.getAttribute(ATT_SOURCE)) != null && tmp.length() > 0) {
            this.setSource(tmp);
        }
        if ((tmp = aElement.getAttribute(ATT_MORELIKETHIS)) != null && tmp.length() > 0) {
            this.setMoreLikeThis(tmp);
        }
        if ((tmp = aElement.getAttribute(ATT_UNAME)) != null && tmp.length() > 0) {
            this.setUName(tmp);
        }
        this.setPpcValue(aElement.getAttribute(ATT_PPCVALUE));
        NodeList nodes = aElement.getChildNodes();
        Node node = null;
        this.resetCells();
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.cells.add(new EPPSuggestionCell((Element)node));
        }
        if (this.cells.size() == 0) {
            this.cells = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.name == null) {
            ExceptionUtil.missingDuringEncode(ATT_NAME);
        }
        root.setAttribute(ATT_NAME, this.name);
        if (this.isSetSource()) {
            root.setAttribute(ATT_SOURCE, this.source);
        }
        if (this.isSetMoreLikeThis()) {
            root.setAttribute(ATT_MORELIKETHIS, this.moreLikeThis);
        }
        if (this.isSetUName()) {
            root.setAttribute(ATT_UNAME, this.uName);
        }
        if (this.ppcValue != null) {
            root.setAttribute(ATT_PPCVALUE, this.ppcValue + "");
        }
        if (this.cells != null) {
            EPPUtil.encodeCompList(aDocument, root, this.cells);
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionRecord other = (EPPSuggestionRecord)o;
            if (!EqualityUtil.equals(this.name, other.name)) {
                return false;
            }
            if (!EqualityUtil.equals(this.source, other.source)) {
                return false;
            }
            if (!EqualityUtil.equals(this.moreLikeThis, other.moreLikeThis)) {
                return false;
            }
            if (!EqualityUtil.equals(this.uName, other.uName)) {
                return false;
            }
            if (!EqualityUtil.equals(this.ppcValue, other.ppcValue)) {
                return false;
            }
            return EqualityUtil.equals(this.cells, other.cells);
        }
        return false;
    }
}

