/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionAction;
import com.verisign.epp.codec.suggestion.EPPSuggestionGeo;
import com.verisign.epp.codec.suggestion.EPPSuggestionTld;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.UnsignedShort;
import com.verisign.epp.codec.suggestion.util.WeightEnum;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPSuggestionFilter
implements EPPCodecComponent {
    private static final long serialVersionUID = 3673430640817334863L;
    private static final String ATT_CONTENTFILTER = "contentfilter";
    private static final String ATT_CUSTOMFILTER = "customfilter";
    private static final String ATT_FORSALE = "forsale";
    private static final String ATT_MAXLENGTH = "maxlength";
    private static final String ATT_MAXRESULTS = "maxresults";
    private static final String ATT_USEHYPHENS = "usehyphens";
    private static final String ATT_USENUMBERS = "usenumbers";
    private static final String ATT_USEIDNS = "useidns";
    private static final String ATT_VIEW = "view";
    private static final String GRID_STRING = "grid";
    private static final Boolean GRID_VIEW = Boolean.FALSE;
    private static final String TABLE_STRING = "table";
    private static final Boolean TABLE_VIEW = Boolean.TRUE;
    private static final String ELM_NAME = "suggestion:filter";
    private HashMap<String, WeightEnum> actionMap = null;
    private ArrayList<EPPSuggestionAction> actions = null;
    private Boolean contentFilter = null;
    private Boolean customFilter = null;
    private WeightEnum forsale = new WeightEnum();
    private UnsignedShort maxLength = new UnsignedShort();
    private UnsignedShort maxResults = new UnsignedShort();
    private ArrayList<EPPSuggestionTld> tlds = null;
    private HashSet<String> tldSet = null;
    private EPPSuggestionGeo geo = null;
    private Boolean useHyphens = null;
    private Boolean useNumbers = null;
    private Boolean useIdns = null;
    private Boolean view = null;

    public EPPSuggestionFilter() {
    }

    public EPPSuggestionFilter(Element aElement) throws EPPDecodeException {
        this();
        this.decode(aElement);
    }

    public void addAction(EPPSuggestionAction aAction) throws InvalidValueException {
        if (aAction == null) {
            throw new InvalidValueException((Object)"Cannot add a null action");
        }
        if (this.actions == null) {
            this.resetActions();
        }
        this.actions.add(aAction);
        this.actionMap.put(aAction.getName().toLowerCase(), aAction.getWeight());
    }

    public void addTld(EPPSuggestionTld aTld) throws InvalidValueException {
        if (aTld == null) {
            throw new InvalidValueException((Object)"Cannot add a null tld");
        }
        if (this.tlds == null) {
            this.resetTlds();
        }
        this.tlds.add(aTld);
        this.tldSet.add(aTld.getTld());
    }

    public void setGeo(EPPSuggestionGeo aGeo) throws InvalidValueException {
        this.geo = aGeo;
    }

    public HashMap<String, WeightEnum> getActionMap() {
        return this.actionMap;
    }

    public ArrayList<EPPSuggestionAction> getActions() {
        return this.actions;
    }

    public EPPSuggestionGeo getGeo() {
        return this.geo;
    }

    public WeightEnum getActionWeight(String aActionName) {
        return this.actionMap.get(aActionName.toLowerCase());
    }

    public Boolean getContentFilter() {
        return this.contentFilter;
    }

    public Boolean getCustomFilter() {
        return this.customFilter;
    }

    public WeightEnum getForsale() {
        return this.forsale;
    }

    public UnsignedShort getMaxLength() {
        return this.maxLength;
    }

    public UnsignedShort getMaxResults() {
        return this.maxResults;
    }

    public ArrayList<EPPSuggestionTld> getTlds() {
        return this.tlds;
    }

    public HashSet<String> getTldSet() {
        return this.tldSet;
    }

    public Boolean getUseHyphens() {
        return this.useHyphens;
    }

    public Boolean getUseNumbers() {
        return this.useNumbers;
    }

    public Boolean getUseIdns() {
        return this.useIdns;
    }

    public Boolean getView() {
        return this.view;
    }

    public String getViewString() {
        if (this.view == null) {
            return null;
        }
        if (this.view.equals(TABLE_VIEW)) {
            return TABLE_STRING;
        }
        return GRID_STRING;
    }

    public boolean hasAction(String aName) {
        return aName != null && this.actionMap != null && this.actionMap.containsKey(aName.toLowerCase());
    }

    public boolean hasTld(String aTld) {
        return aTld != null && this.tldSet != null && this.tldSet.contains(aTld);
    }

    public boolean isGeo() {
        return this.geo != null;
    }

    public boolean isGrid() {
        if (this.view != null) {
            return this.view == false;
        }
        return false;
    }

    public boolean isTable() {
        if (this.view != null) {
            return this.view;
        }
        return false;
    }

    public void resetActions() {
        this.actions = new ArrayList();
        this.actionMap = new HashMap();
    }

    public void resetTlds() {
        this.tlds = new ArrayList();
        this.tldSet = new HashSet();
    }

    public void setContentFilter(boolean aContentFilter) {
        this.contentFilter = new Boolean(aContentFilter);
    }

    public void setContentFilter(String aContentFilterAsString) {
        if (aContentFilterAsString != null && aContentFilterAsString.length() > 0) {
            this.contentFilter = new Boolean(aContentFilterAsString);
        }
    }

    public void setCustomFilter(boolean aCustomfilter) {
        this.customFilter = new Boolean(aCustomfilter);
    }

    public void setCustomFilter(String aCustomfilterAsString) {
        if (aCustomfilterAsString != null && aCustomfilterAsString.length() > 0) {
            this.customFilter = new Boolean(aCustomfilterAsString);
        }
    }

    public void setForSale(String aForsale) throws InvalidValueException {
        this.forsale.set(aForsale);
    }

    public void setGridView() {
        this.view = GRID_VIEW;
    }

    public void setMaxLength(short aMaxLength) throws InvalidValueException {
        this.maxLength.set(aMaxLength);
    }

    public void setMaxLength(String aMaxLengthAsString) throws InvalidValueException {
        this.maxLength.set(aMaxLengthAsString);
    }

    public void setMaxResults(short aMaxResults) throws InvalidValueException {
        this.maxResults.set(aMaxResults);
    }

    public void setMaxResults(String aMaxResultsAsString) throws InvalidValueException {
        this.maxResults.set(aMaxResultsAsString);
    }

    public void setTableView() {
        this.view = TABLE_VIEW;
    }

    public void setUseHyphens(boolean aUseHyphens) {
        this.useHyphens = new Boolean(aUseHyphens);
    }

    public void setUseHyphens(String aUseHyphensAsString) {
        if (aUseHyphensAsString != null && aUseHyphensAsString.length() > 0) {
            this.useHyphens = new Boolean(aUseHyphensAsString);
        }
    }

    public void setUseNumbers(boolean aUseNumbers) {
        this.useNumbers = new Boolean(aUseNumbers);
    }

    public void setUseNumbers(String aUseNumbersAsString) {
        if (aUseNumbersAsString != null && aUseNumbersAsString.length() > 0) {
            this.useNumbers = new Boolean(aUseNumbersAsString);
        }
    }

    public void setUseIdns(boolean aUseIdns) {
        this.useIdns = new Boolean(aUseIdns);
    }

    public void setUseIdns(String aUseIdnsAsString) {
        if (aUseIdnsAsString != null && aUseIdnsAsString.length() > 0) {
            this.useIdns = new Boolean(aUseIdnsAsString);
        }
    }

    public void setView(String aViewAsString) throws InvalidValueException {
        if (aViewAsString == null || aViewAsString.length() == 0) {
            this.view = null;
        } else if (aViewAsString.equalsIgnoreCase(TABLE_STRING)) {
            this.setTableView();
        } else if (aViewAsString.equalsIgnoreCase(GRID_STRING)) {
            this.setGridView();
        } else {
            throw new InvalidValueException((Object)aViewAsString);
        }
    }

    public String toLogString() {
        int i;
        int size;
        StringBuffer out = new StringBuffer();
        out.append("cf:" + EPPSuggestionFilter.abbreviate(this.contentFilter));
        out.append(" uf:" + EPPSuggestionFilter.abbreviate(this.customFilter));
        out.append(" fs:" + this.forsale.toLogString());
        out.append(" ml:" + this.maxLength);
        out.append(" mr:" + this.maxResults);
        out.append(" uh:" + EPPSuggestionFilter.abbreviate(this.useHyphens));
        out.append(" un:" + EPPSuggestionFilter.abbreviate(this.useNumbers));
        out.append(" ui:" + EPPSuggestionFilter.abbreviate(this.useIdns));
        out.append(" vw:" + EPPSuggestionFilter.abbreviate(this.view));
        out.append(" action:");
        if (this.actions != null && this.actions.size() > 0) {
            size = this.actions.size();
            if (size > 0) {
                out.append(this.actions.get(0).toLogString());
            }
            for (i = 1; i < size; ++i) {
                out.append("," + this.actions.get(i).toLogString());
            }
        }
        out.append(" tld:");
        if (this.tlds != null && this.tlds.size() > 0) {
            size = this.tlds.size();
            if (size > 0) {
                out.append(this.tlds.get(0).toLogString());
            }
            for (i = 1; i < size; ++i) {
                out.append("," + this.tlds.get(i).toLogString());
            }
        }
        out.append(" geo:");
        if (this.geo != null) {
            out.append(this.geo.toLogString());
        }
        return out.toString();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionFilter)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        NodeList nodes = aElement.getChildNodes();
        Node node = null;
        int size = nodes.getLength();
        if (size > 0) {
            String name = null;
            for (int i = 0; i < size; ++i) {
                node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                name = node.getLocalName();
                if (name.equals(EPPUtil.getLocalName("suggestion:tld"))) {
                    this.addTld(new EPPSuggestionTld((Element)node));
                    continue;
                }
                if (name.equals(EPPUtil.getLocalName("suggestion:action"))) {
                    this.addAction(new EPPSuggestionAction((Element)node));
                    continue;
                }
                if (!name.equals(EPPUtil.getLocalName("suggestion:geo"))) continue;
                this.setGeo(new EPPSuggestionGeo((Element)node));
            }
        }
        this.setContentFilter(aElement.getAttribute(ATT_CONTENTFILTER));
        this.setCustomFilter(aElement.getAttribute(ATT_CUSTOMFILTER));
        this.setForSale(aElement.getAttribute(ATT_FORSALE));
        this.setMaxLength(aElement.getAttribute(ATT_MAXLENGTH));
        this.setMaxResults(aElement.getAttribute(ATT_MAXRESULTS));
        this.setUseHyphens(aElement.getAttribute(ATT_USEHYPHENS));
        this.setUseNumbers(aElement.getAttribute(ATT_USENUMBERS));
        this.setUseIdns(aElement.getAttribute(ATT_USEIDNS));
        this.setView(aElement.getAttribute(ATT_VIEW));
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.actions != null) {
            EPPUtil.encodeCompList(aDocument, root, this.actions);
        }
        if (this.tlds != null) {
            EPPUtil.encodeCompList(aDocument, root, this.tlds);
        }
        if (this.geo != null) {
            EPPUtil.encodeComp(aDocument, root, this.geo);
        }
        if (this.contentFilter != null) {
            root.setAttribute(ATT_CONTENTFILTER, this.contentFilter.toString());
        }
        if (this.customFilter != null) {
            root.setAttribute(ATT_CUSTOMFILTER, this.customFilter.toString());
        }
        if (this.forsale.isSet()) {
            root.setAttribute(ATT_FORSALE, this.forsale.toString());
        }
        if (this.maxLength.isSet()) {
            root.setAttribute(ATT_MAXLENGTH, this.maxLength.toString());
        }
        if (this.maxResults.isSet()) {
            root.setAttribute(ATT_MAXRESULTS, this.maxResults.toString());
        }
        if (this.useHyphens != null) {
            root.setAttribute(ATT_USEHYPHENS, this.useHyphens.toString());
        }
        if (this.useNumbers != null) {
            root.setAttribute(ATT_USENUMBERS, this.useNumbers.toString());
        }
        if (this.useIdns != null) {
            root.setAttribute(ATT_USEIDNS, this.useIdns.toString());
        }
        if (this.view != null) {
            root.setAttribute(ATT_VIEW, this.getViewString());
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionFilter other = (EPPSuggestionFilter)o;
            if (!EqualityUtil.equals(this.actions, other.actions)) {
                return false;
            }
            if (!EqualityUtil.equals(this.tlds, other.tlds)) {
                return false;
            }
            if (!EqualityUtil.equals(this.geo, other.geo)) {
                return false;
            }
            if (!EqualityUtil.equals(this.contentFilter, other.contentFilter)) {
                return false;
            }
            if (!EqualityUtil.equals(this.customFilter, other.customFilter)) {
                return false;
            }
            if (!this.forsale.equals(other.forsale)) {
                return false;
            }
            if (!this.maxLength.equals(other.maxLength)) {
                return false;
            }
            if (!this.maxResults.equals(other.maxResults)) {
                return false;
            }
            if (!EqualityUtil.equals(this.useHyphens, other.useHyphens)) {
                return false;
            }
            if (!EqualityUtil.equals(this.useNumbers, other.useNumbers)) {
                return false;
            }
            if (!EqualityUtil.equals(this.useIdns, other.useIdns)) {
                return false;
            }
            return EqualityUtil.equals(this.view, other.view);
        }
        return false;
    }

    private static String abbreviate(Boolean aBoolean) {
        if (aBoolean == null) {
            return "";
        }
        if (aBoolean.booleanValue()) {
            return "t";
        }
        return "f";
    }
}

