/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgppoll;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgppoll.EPPRgpPollStatus;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpPollResponse
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPRgpPollResponse.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "rgp-poll:pollData";
    public static final String ELM_DOMAIN_NAME = "rgp-poll:name";
    public static final String ELM_REQ_DATE = "rgp-poll:reqDate";
    public static final String ELM_DUE_DATE = "rgp-poll:reportDueDate";
    private EPPRgpPollStatus status;
    private String name;
    private Date reqDate;
    private Date reportDueDate;

    public Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpPollData.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpPollData invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpPollData.doEncode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/rgp-poll-1.0", ELM_NAME);
        root.setAttribute("xmlns:rgp-poll", "http://www.verisign.com/epp/rgp-poll-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/rgp-poll-1.0 rgp-poll-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_DOMAIN_NAME);
        EPPUtil.encodeComp(aDocument, root, this.status);
        EPPUtil.encodeTimeInstant(aDocument, root, this.reqDate, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_REQ_DATE);
        EPPUtil.encodeTimeInstant(aDocument, root, this.reportDueDate, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_DUE_DATE);
        return root;
    }

    public void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_DOMAIN_NAME);
        this.status = (EPPRgpPollStatus)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/rgp-poll-1.0", "rgp-poll:rgpStatus", EPPRgpPollStatus.class);
        this.reqDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_REQ_DATE);
        this.reportDueDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/rgp-poll-1.0", ELM_DUE_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpPollResponse)) {
            return false;
        }
        EPPRgpPollResponse theComp = (EPPRgpPollResponse)aObject;
        if (!(this.status != null ? this.status.equals(theComp.status) : theComp.status == null)) {
            return false;
        }
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.reqDate != null ? this.reqDate.equals(theComp.reqDate) : theComp.reqDate == null)) {
            return false;
        }
        return this.reportDueDate != null ? this.reportDueDate.equals(theComp.reportDueDate) : theComp.reportDueDate == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRgpPollResponse clone = null;
        clone = (EPPRgpPollResponse)super.clone();
        clone.name = this.name;
        clone.reqDate = this.reqDate;
        clone.reportDueDate = this.reportDueDate;
        if (this.status != null) {
            clone.status = (EPPRgpPollStatus)this.status.clone();
        }
        return clone;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("EPPRgpPollData required attribute is not set");
        }
        if (this.status == null) {
            throw new EPPCodecException("EPPRgpPollData required attribute is not set");
        }
        if (this.reqDate == null) {
            throw new EPPCodecException("EPPRgpPollData required attribute is not set");
        }
        if (this.reportDueDate == null) {
            throw new EPPCodecException("EPPRgpPollData required attribute is not set");
        }
    }

    public EPPRgpPollStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPRgpPollStatus aStatus) {
        this.status = aStatus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getReqDate() {
        return this.reqDate;
    }

    public void setReqDate(Date reqDate) {
        this.reqDate = reqDate;
    }

    public Date getReportDueDate() {
        return this.reportDueDate;
    }

    public void setReportDueDate(Date reportDueDate) {
        this.reportDueDate = reportDueDate;
    }
}

