/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpExtUpData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRgpExtUpData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "rgp:upData";
    private EPPRgpExtStatus status;

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:rgp-1.0";
    }

    public EPPRgpExtUpData() {
    }

    public EPPRgpExtUpData(EPPRgpExtStatus aStatus) {
        this.status = aStatus;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpExtUpData.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpExtUpData invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtUpData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        root.setAttribute("xmlns:rgp", "urn:ietf:params:xml:ns:rgp-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:rgp-1.0 rgp-1.0.xsd");
        EPPUtil.encodeComp(aDocument, root, this.status);
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.status = (EPPRgpExtStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "rgp:rgpStatus", EPPRgpExtStatus.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtUpData)) {
            return false;
        }
        EPPRgpExtUpData theComp = (EPPRgpExtUpData)aObject;
        return this.status != null ? this.status.equals(theComp.status) : theComp.status == null;
    }

    void validateState() throws EPPCodecException {
        if (this.status == null) {
            throw new EPPCodecException("EPPRgpExtStatus required attribute is not set");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtUpData clone = null;
        clone = (EPPRgpExtUpData)super.clone();
        clone.setStatus((EPPRgpExtStatus)this.status.clone());
        return clone;
    }

    public EPPRgpExtStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPRgpExtStatus status) {
        this.status = status;
    }
}

