/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPRgpExtReportText
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRgpExtReportText.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_DEFAULT_LANG = "en";
    static final String ELM_LANG = "lang";
    public static final String ELM_RES_REASON = "resReason";
    public static final String ELM_STATEMENT = "statement";
    private String lang = "en";
    private String message;
    private String localName;

    public EPPRgpExtReportText() {
    }

    public EPPRgpExtReportText(String aMessage) {
        this.message = aMessage;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpExtReport.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpExtReport invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtReport.encode(Document)");
        }
        Element root = null;
        if (this.localName.equals(ELM_RES_REASON)) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", "rgp:resReason");
        } else if (this.localName.equals(ELM_STATEMENT)) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", "rgp:statement");
        } else {
            throw new EPPEncodeException("Method encode() value for tagname is invalid.  Should be either rgp:statement or rgp:resReason");
        }
        if (this.message != null) {
            if (!this.lang.equals(ELM_DEFAULT_LANG)) {
                root.setAttribute(ELM_LANG, this.lang);
            }
            Text descVal = aDocument.createTextNode(this.message);
            root.appendChild(descVal);
        }
        return root;
    }

    void validateState() throws EPPCodecException {
        if (this.message == null) {
            throw new EPPCodecException("EPPRgpExtReportText required attribute message is not set ");
        }
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.localName = aElement.getLocalName();
        Node msgNode = aElement.getFirstChild();
        if (msgNode != null) {
            this.message = msgNode.getNodeValue();
            this.lang = aElement.getAttribute(ELM_LANG);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtReportText)) {
            return false;
        }
        EPPRgpExtReportText theComp = (EPPRgpExtReportText)aObject;
        return this.message != null ? this.message.equals(theComp.message) : theComp.message == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtReportText clone = null;
        clone = (EPPRgpExtReportText)super.clone();
        clone.localName = this.localName;
        clone.message = this.message;
        clone.lang = this.lang;
        return clone;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }
}

