/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPRelatedDomainExtUpdate
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = Logger.getLogger((String)EPPRelatedDomainExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "relDom:update";
    public static final String ELM_DOMAIN_NAME = "relDom:name";
    private List<String> domainNames = null;

    public EPPRelatedDomainExtUpdate() {
    }

    public EPPRelatedDomainExtUpdate(List<String> aDomains) {
        this.domainNames = aDomains;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtUpdate theClone = new EPPRelatedDomainExtUpdate();
        if (this.domainNames != null) {
            theClone.domainNames = new ArrayList<String>();
            for (String domainName : this.domainNames) {
                if (domainName != null) {
                    theClone.domainNames.add(domainName);
                    continue;
                }
                theClone.domainNames.add(null);
            }
        } else {
            theClone.domainNames = null;
        }
        return theClone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domainNames = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", ELM_DOMAIN_NAME);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRelatedDomainExtUpdate.decode: " + e);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtUpdate.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRelatedDomainExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRelatedDomainExtUpdate invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.domainNames, "http://www.verisign.com/epp/relatedDomain-1.0", ELM_DOMAIN_NAME);
        return root;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPRelatedDomainExtUpdate)) {
            return false;
        }
        EPPRelatedDomainExtUpdate theComp = (EPPRelatedDomainExtUpdate)aObj;
        if (!EPPUtil.equalLists(this.domainNames, theComp.domainNames)) {
            cat.error((Object)"EPPRelatedDomainExtUpdate.equals(): availableDomains not equal");
            return false;
        }
        return true;
    }

    public void addDomain(String aDomainName) {
        if (this.domainNames == null) {
            this.domainNames = new ArrayList<String>();
        }
        this.domainNames.add(aDomainName);
    }

    public boolean hasDomains() {
        return this.domainNames != null && this.domainNames.size() > 0;
    }

    public List<String> getDomains() {
        return this.domainNames;
    }

    public void setDomains(List<String> aDomains) {
        this.domainNames = aDomains;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    private void validateState() throws EPPCodecException {
        if (this.domainNames == null || this.domainNames.size() == 0) {
            throw new EPPCodecException("EPPRelatedDomainExtUpdate contains no elements.");
        }
        for (String domainName : this.domainNames) {
            if (domainName != null) continue;
            throw new EPPCodecException("EPPRelatedDomainExtUpdate: name element cannot be null.");
        }
    }
}

