/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.registry.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.EPPRegistryContact;
import com.verisign.epp.codec.registry.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.EPPRegistryContactName;
import com.verisign.epp.codec.registry.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.EPPRegistryDS;
import com.verisign.epp.codec.registry.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.EPPRegistryDomain;
import com.verisign.epp.codec.registry.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.EPPRegistryFields;
import com.verisign.epp.codec.registry.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.EPPRegistryHost;
import com.verisign.epp.codec.registry.EPPRegistryIDN;
import com.verisign.epp.codec.registry.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.EPPRegistryKeyValue;
import com.verisign.epp.codec.registry.EPPRegistryLanguageType;
import com.verisign.epp.codec.registry.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPhase;
import com.verisign.epp.codec.registry.EPPRegistryPostal;
import com.verisign.epp.codec.registry.EPPRegistryRGP;
import com.verisign.epp.codec.registry.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistryRelated;
import com.verisign.epp.codec.registry.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.EPPRegistrySLA;
import com.verisign.epp.codec.registry.EPPRegistrySLAInfo;
import com.verisign.epp.codec.registry.EPPRegistryServices;
import com.verisign.epp.codec.registry.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.EPPRegistryZone;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import com.verisign.epp.codec.registry.EPPRegistryZoneList;
import com.verisign.epp.codec.registry.EPPRegistryZoneMember;
import com.verisign.epp.util.TestThread;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPRegistryTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPRegistryTst(String name) {
        super(name);
    }

    public void testRegistryInfo() {
        EPPCodecTst.printStart("testRegistryInfo");
        EPPRegistryInfoCmd theCommand = new EPPRegistryInfoCmd("ABC-12349", true);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryZoneList zoneList = new EPPRegistryZoneList();
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(respTransId, zoneList);
        zoneList.addZone(new EPPRegistryZone("com", new Date(), new Date()));
        zoneList.addZone(new EPPRegistryZone("love", new Date()));
        zoneList.addZone(new EPPRegistryZone("tree", new Date(), new Date()));
        zoneList.addZone(new EPPRegistryZone("coffee", new Date(), new Date()));
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPRegistryInfoCmd("ABC-12349", "com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryZoneInfo zoneInfo = this.createZoneInfo();
        theResponse = new EPPRegistryInfoResp(respTransId, zoneInfo);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        zoneInfo.setContact(null);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfo");
    }

    private EPPRegistryZoneInfo createZoneInfo() {
        EPPRegistryZoneInfo zoneInfo = new EPPRegistryZoneInfo("com");
        zoneInfo.setGroup("1");
        zoneInfo.setSubProduct("dotCom");
        EPPRegistryRelated related = new EPPRegistryRelated();
        EPPRegistryFields fields = new EPPRegistryFields();
        fields.setType("sync");
        fields.addField("clID");
        fields.addField("registrant");
        fields.addField("ns");
        related.setFields(fields);
        related.addMember(new EPPRegistryZoneMember("EXAMPLE", "equal"));
        related.addMember(new EPPRegistryZoneMember("EXAMPLE2", "equal"));
        related.addMember(new EPPRegistryZoneMember("EXAMPLE3", "equal"));
        zoneInfo.setRelated(related);
        EPPRegistryPhase phase = new EPPRegistryPhase("sunrise", new Date(), new Date());
        phase.setMode("pending-application");
        zoneInfo.addPhase(phase);
        phase = new EPPRegistryPhase("pre-delegation", new Date(), new Date());
        phase.setMode("pending-registration");
        zoneInfo.addPhase(phase);
        zoneInfo.addPhase(new EPPRegistryPhase("landrush", new Date(), new Date()));
        zoneInfo.addPhase(new EPPRegistryPhase("pre-delegation", new Date(), new Date()));
        zoneInfo.addPhase(new EPPRegistryPhase("claims", new Date(), new Date()));
        zoneInfo.addPhase(new EPPRegistryPhase("open", new Date()));
        zoneInfo.addPhase(new EPPRegistryPhase("custom", "userDefined", new Date()));
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/rgp-poll-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:host-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:contact-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:domain-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/lowbalance-poll-1.0", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign-grs.com/epp/namestoreExt-1.1", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:rgp-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/sync-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/idnLang-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/jobsContact-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/premiumdomain-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:secDNS-1.1", Boolean.FALSE));
        zoneInfo.setServices(services);
        EPPRegistrySLAInfo slaInfo = new EPPRegistrySLAInfo();
        slaInfo.addSla(new EPPRegistrySLA("response", "ext", "create", 500.0, "ms"));
        slaInfo.addSla(new EPPRegistrySLA("availability", null, "create", 99.9, "percent"));
        zoneInfo.setSlaInfo(slaInfo);
        zoneInfo.setCreatedBy("crId");
        zoneInfo.setCreatedDate(new Date());
        zoneInfo.setLastUpdatedBy("upId");
        zoneInfo.setLastUpdatedDate(new Date());
        zoneInfo.setDomain(this.buildInfoDomain());
        zoneInfo.setHost(this.buildInfoHost());
        zoneInfo.setContact(this.buildContact());
        return zoneInfo;
    }

    public void testRegistryCheck() {
        EPPCodecTst.printStart("testRegistryCheck");
        EPPRegistryCheckCmd theCommand = new EPPRegistryCheckCmd("ABC-12345", "com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPRegistryCheckCmd("ABC-12345", "com");
        theCommand.addName("weirdname");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryCheckResult result = new EPPRegistryCheckResult("com", Boolean.FALSE);
        result.setReason("Already taken");
        EPPRegistryCheckResp theResponse = new EPPRegistryCheckResp(respTransId, result);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        ArrayList<EPPRegistryCheckResult> results = new ArrayList<EPPRegistryCheckResult>();
        result = new EPPRegistryCheckResult("com", Boolean.FALSE);
        result.setReason("Already taken");
        results.add(result);
        results.add(new EPPRegistryCheckResult("availtld", Boolean.FALSE));
        theResponse = new EPPRegistryCheckResp(respTransId, results);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryCheck");
    }

    public void testRegistryCreate() {
        EPPCodecTst.printStart("testRegistryCreate");
        EPPRegistryZoneInfo zone = this.createZoneInfo();
        zone.setName("newtld");
        EPPRegistryCreateCmd theCommand = null;
        theCommand = new EPPRegistryCreateCmd("ABC-12349", zone);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryCreateResp theResponse = new EPPRegistryCreateResp(respTransId, "newtld");
        Calendar baseCal = Calendar.getInstance();
        Calendar endCal = (Calendar)baseCal.clone();
        theResponse.setCreateDate(baseCal.getTime());
        endCal = (Calendar)baseCal.clone();
        endCal.add(2, 9);
        endCal.add(1, 10);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryCreate");
    }

    public void testRegistryUpdate() {
        EPPCodecTst.printStart("testRegistryUpdate");
        EPPRegistryZoneInfo zone = new EPPRegistryZoneInfo();
        zone.setName("newtld");
        EPPRegistryUpdateCmd theCommand = null;
        theCommand = new EPPRegistryUpdateCmd("ABC-12349", zone);
        zone.setDomain(this.buildInfoDomain());
        zone.setHost(this.buildInfoHost());
        zone.setContact(this.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/registry-1.0", Boolean.TRUE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/registry-1.0", Boolean.TRUE));
        zone.setServices(services);
        EPPRegistrySLAInfo slaInfo = new EPPRegistrySLAInfo();
        slaInfo.addSla(new EPPRegistrySLA("response", "ext", "create", 500.0, "ms"));
        slaInfo.addSla(new EPPRegistrySLA("availability", null, "create", 99.9, "percent"));
        zone.setSlaInfo(slaInfo);
        zone.setCreatedBy("crId");
        zone.setCreatedDate(new Date());
        Calendar baseCal = Calendar.getInstance();
        Calendar startCal = (Calendar)baseCal.clone();
        Calendar endCal = (Calendar)baseCal.clone();
        endCal.add(2, 3);
        EPPRegistryPhase phase = new EPPRegistryPhase("sunrise", new Date(), new Date());
        phase.setMode("pending-application");
        zone.addPhase(phase);
        phase = new EPPRegistryPhase("pre-delegation", new Date(), new Date());
        phase.setMode("pending-registration");
        zone.addPhase(phase);
        zone.addPhase(new EPPRegistryPhase("landrush", new Date(), new Date()));
        zone.addPhase(new EPPRegistryPhase("pre-delegation", new Date(), new Date()));
        zone.addPhase(new EPPRegistryPhase("claims", new Date(), new Date()));
        zone.addPhase(new EPPRegistryPhase("open", new Date()));
        zone.addPhase(new EPPRegistryPhase("custom", "userDefined", new Date()));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryUpdate");
    }

    public void testRegistryDelete() {
        EPPCodecTst.printStart("testRegistryDelete");
        EPPRegistryDeleteCmd theCommand = null;
        theCommand = new EPPRegistryDeleteCmd("ABC-12349", "newetld");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryDelete");
    }

    private EPPRegistryDomain buildInfoDomain() {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(new Integer(2));
        domainName.setMinLength(new Integer(5));
        domainName.setMaxLength(new Integer(50));
        domainName.setAlphaNumStart(new Boolean(true));
        domainName.setAlphaNumEnd(new Boolean(false));
        domainName.setOnlyDnsChars(new Boolean(true));
        ArrayList<EPPRegistryRegex> regex = new ArrayList<EPPRegistryRegex>();
        EPPRegistryRegex r = new EPPRegistryRegex("^\\w+.*$", "test regex");
        regex.add(r);
        r = new EPPRegistryRegex("^\\d+.*$");
        regex.add(r);
        domainName.setRegex(regex);
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved1");
        rNames.add("reserved2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(new Integer(3));
            domainName.getReservedNames().setReservedNames(new ArrayList());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            EPPRegistryTst.fail((String)"failed to clone domainName");
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguageType("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", "restricted"));
        idn.addLanguage(new EPPRegistryLanguageType("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", "blocked"));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(new Boolean(true));
        domain.setContactsSupported(new Boolean(false));
        domain.addContact(new EPPRegistryDomainContact("admin", 1, 4));
        domain.addContact(new EPPRegistryDomainContact("billing", 2, 5));
        domain.addContact(new EPPRegistryDomainContact("tech", 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        domain.setChildHostLimit(new EPPRegistryDomainHostLimit(2, 32));
        domain.addPeriod(new EPPRegistryDomainPeriod("create", Boolean.TRUE));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, "y", 60, "m", 5, "y"));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, "y", 8, "y", 3, "y"));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(5, "d"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, "d"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, "h"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, "m"));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, "m"));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, "m"));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, "m"));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        EPPRegistryDS ds = new EPPRegistryDS(1, 3, null, null);
        ds.addAlgorithm("algDS1");
        ds.addAlgorithm("algDS2");
        ds.addDigestType("digest1");
        ds.addDigestType("digest2");
        dnssec.setDs(ds);
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(new Integer(12));
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("dk1", "dv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("dk2", "dv2"));
        domain.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        return domain;
    }

    private EPPRegistryHost buildInfoHost() {
        EPPRegistryHost host = new EPPRegistryHost();
        host.setInternal(new EPPRegistryInternalHost(5, 15, "perZone"));
        host.setExternal(new EPPRegistryExternalHost(2, 12, "perZone"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp1"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp2"));
        host.setMaxCheckHost(new Integer(15));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("hk1", "hv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("hk2", "hv2"));
        host.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        host.setSupportedStatus(supportedStatus);
        return host;
    }

    private EPPRegistryContact buildContact() {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setLocSupport(Boolean.TRUE);
        contact.setIntSupport(Boolean.FALSE);
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("ck1", "cv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("ck2", "cv2"));
        contact.setCustomData(customData);
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setSharePolicy("perZone");
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(new Integer(15));
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setName(new EPPRegistryContactName(5, 15));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        ArrayList<EPPRegistryRegex> emailRegex = new ArrayList<EPPRegistryRegex>();
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp"));
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp in ch", "ch"));
        postalInfo.setEmailRegex(emailRegex);
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        contact.setMaxCheckContact(new Integer(5));
        contact.setPostalInfo(postalInfo);
        contact.setClientDisclosureSupported(Boolean.TRUE);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        contact.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(5, "d"));
        return contact;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRegistryTst Thread " + i, EPPRegistryTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRegistryTst.suite());
        }
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPRegistryTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.registry.EPPRegistryMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPRegistryMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

