/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryReservedNames
implements EPPCodecComponent {
    private static final long serialVersionUID = -483506152124947305L;
    static final String ELM_NAME = "registry:reservedNames";
    static final String ELM_RESERVED_NAME = "registry:reservedName";
    static final String ELM_RESERVED_NAME_URI = "registry:reservedNameURI";
    private List reservedNames = new ArrayList();
    private String reservedNameURI = null;

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryReservedNames.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        if (this.reservedNames != null && this.reservedNames.size() > 0) {
            EPPUtil.encodeList(aDocument, root, this.reservedNames, "http://www.verisign.com/epp/registry-1.0", ELM_RESERVED_NAME);
        }
        if (this.reservedNameURI != null && this.reservedNameURI.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.reservedNameURI, "http://www.verisign.com/epp/registry-1.0", ELM_RESERVED_NAME_URI);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.reservedNames = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_RESERVED_NAME);
        this.reservedNameURI = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_RESERVED_NAME_URI);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryReservedNames)) {
            return false;
        }
        EPPRegistryReservedNames theComp = (EPPRegistryReservedNames)aObject;
        if (!(this.reservedNames != null ? EPPUtil.equalLists(this.reservedNames, theComp.reservedNames) : theComp.reservedNames == null)) {
            return false;
        }
        return this.reservedNameURI != null ? this.reservedNameURI.equals(theComp.reservedNameURI) : theComp.reservedNameURI == null;
    }

    void validateState() throws EPPCodecException {
        if (this.reservedNames != null && this.reservedNames.size() > 0 && this.reservedNameURI != null && this.reservedNameURI.trim().length() > 0) {
            throw new EPPCodecException("reservedNames and reservedNameURI cannot be used together");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryReservedNames clone = (EPPRegistryReservedNames)super.clone();
        if (this.reservedNames != null) {
            clone.reservedNames = (List)((ArrayList)this.reservedNames).clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public List getReservedNames() {
        return this.reservedNames;
    }

    public void setReservedNames(List reservedNames) {
        this.reservedNames = reservedNames;
    }

    public void addReservedName(String reservedName) {
        if (this.reservedNames == null) {
            this.reservedNames = new ArrayList();
        }
        this.reservedNames.add(reservedName);
    }

    public String getReservedNameURI() {
        return this.reservedNameURI;
    }

    public void setReservedNameURI(String reservedNameURI) {
        this.reservedNameURI = reservedNameURI;
    }
}

