/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryFields;
import com.verisign.epp.codec.registry.EPPRegistryZoneMember;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPRegistryRelated
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger(EPPRegistryRelated.class);
    public static final String ELM_LOCALNAME = "related";
    public static final String ELM_NAME = "registry:related";
    private EPPRegistryFields fields;
    private List<EPPRegistryZoneMember> members;

    public EPPRegistryRelated() {
        this.members = new ArrayList<EPPRegistryZoneMember>();
    }

    public EPPRegistryRelated(List<EPPRegistryZoneMember> aMembers) {
        this.members = aMembers;
    }

    public EPPRegistryRelated(List<EPPRegistryZoneMember> aMembers, EPPRegistryFields aFields) {
        this.members = aMembers;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryRelated.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.fields);
        EPPUtil.encodeCompList(aDocument, root, this.members);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.fields = (EPPRegistryFields)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:fields", EPPRegistryFields.class);
        this.members = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:zoneMember", EPPRegistryZoneMember.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryRelated clone = (EPPRegistryRelated)super.clone();
        if (this.fields != null) {
            clone.fields = (EPPRegistryFields)this.fields.clone();
        }
        if (this.members != null) {
            clone.members = (List)((ArrayList)this.members).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRelated)) {
            return false;
        }
        EPPRegistryRelated theComp = (EPPRegistryRelated)aObject;
        if (!EqualityUtil.equals(this.fields, theComp.fields)) {
            cat.error((Object)"EPPRegistryRelated.equals(): fields not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.members, theComp.members)) {
            cat.error((Object)"EPPRegistryRelated.equals(): members not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.members == null || this.members.size() == 0) {
            throw new EPPCodecException("There should have at least one zone member in the zone members");
        }
    }

    public EPPRegistryFields getFields() {
        return this.fields;
    }

    public void setFields(EPPRegistryFields aFields) {
        this.fields = aFields;
    }

    public boolean hasFields() {
        return this.fields != null;
    }

    public List<EPPRegistryZoneMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<EPPRegistryZoneMember> aMembers) {
        this.members = aMembers;
    }

    public void addMember(EPPRegistryZoneMember aMember) {
        if (this.members == null) {
            this.members = new ArrayList<EPPRegistryZoneMember>();
        }
        this.members.add(aMember);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

