/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryRegex
implements EPPCodecComponent {
    private static final long serialVersionUID = 6061392945665281499L;
    public static final String ELM_EXPRESSION = "registry:expression";
    public static final String ELM_EXPLANATION = "registry:explanation";
    public static final String ATTR_LANG = "lang";
    private String rootName = null;
    private String expression = null;
    private String explanation = null;
    private String lang = null;

    public EPPRegistryRegex() {
    }

    public EPPRegistryRegex(String expression) {
        this();
        this.expression = expression;
    }

    public EPPRegistryRegex(String expression, String explanation) {
        this(expression);
        this.explanation = explanation;
    }

    public EPPRegistryRegex(String expression, String explanation, String lang) {
        this(expression);
        this.explanation = explanation;
        this.lang = lang;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPEncodeException("rootName is not set");
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPEncodeException("expression attribute is not set in EPPRegistryRegex.encode");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.expression, "http://www.verisign.com/epp/registry-1.0", ELM_EXPRESSION);
        if (this.explanation != null && this.explanation.trim().length() > 0) {
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
            Element currElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_EXPLANATION);
            Text currVal = aDocument.createTextNode(this.explanation);
            currElm.setAttribute(ATTR_LANG, this.lang);
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.expression = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPRESSION);
        this.explanation = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPLANATION);
        if (this.explanation != null) {
            Element theElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EXPLANATION);
            this.lang = theElm.getAttribute(ATTR_LANG);
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPDecodeException("expression attribute is not set in EPPRegistryRegex.decode");
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryRegex)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRegex)) {
            return false;
        }
        EPPRegistryRegex theComp = (EPPRegistryRegex)aObject;
        if (!(this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null)) {
            return false;
        }
        if (!(this.expression != null ? this.expression.equals(theComp.expression) : theComp.expression == null)) {
            return false;
        }
        if (!(this.explanation != null ? this.explanation.equals(theComp.explanation) : theComp.explanation == null)) {
            return false;
        }
        return this.explanation == null || (this.lang != null ? this.lang.equals(theComp.lang) : theComp.lang == null);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    String getRootName() {
        return this.rootName;
    }

    void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

