/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class EPPRegistryPeriodType
implements EPPCodecComponent {
    private static final long serialVersionUID = -3138571257611606559L;
    private static final String ELM_PERIOD_UNIT = "unit";
    public static final String PERIOD_UNIT_MONTH = "m";
    public static final String PERIOD_UNIT_YEAR = "y";
    public static final String PERIOD_UNIT_DAY = "d";
    public static final String PERIOD_UNIT_HOUR = "h";
    public static final Set VALID_UNITS = new HashSet();
    protected String rootName = "registry:period";
    public static final String ELM_NAME = "registry:period";
    protected Integer number = null;
    protected String unit = null;

    public EPPRegistryPeriodType() {
    }

    public EPPRegistryPeriodType(Integer number, String unit) {
        this();
        this.number = number;
        this.unit = unit;
    }

    public EPPRegistryPeriodType(int number, String unit) {
        this();
        this.number = new Integer(number);
        this.unit = unit;
    }

    public String getRootName() {
        return this.rootName;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        Text currVal = aDocument.createTextNode(String.valueOf(this.number));
        root.setAttribute(ELM_PERIOD_UNIT, this.unit);
        root.appendChild(currVal);
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement != null) {
            Node textNode = aElement.getFirstChild();
            if (textNode != null) {
                String intValStr = textNode.getNodeValue();
                try {
                    this.number = Integer.valueOf(intValStr);
                }
                catch (NumberFormatException e) {
                    throw new EPPDecodeException("Can't convert value to Integer: " + intValStr + e);
                }
            } else {
                throw new EPPDecodeException("Can't decode numeric value from non-existant text node");
            }
        }
        this.unit = aElement.getAttribute(ELM_PERIOD_UNIT);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryPeriodType)) {
            return false;
        }
        EPPRegistryPeriodType theComp = (EPPRegistryPeriodType)aObject;
        if (!(this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null)) {
            return false;
        }
        if (!(this.number != null ? this.number.equals(theComp.number) : theComp.number == null)) {
            return false;
        }
        return this.unit != null ? this.unit.equals(theComp.unit) : theComp.unit == null;
    }

    void validateState() throws EPPCodecException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPCodecException("rootName is not set");
        }
        if (this.number == null) {
            throw new EPPCodecException(this.getRootName() + ": number should not be null");
        }
        if (this.unit == null || this.unit.length() == 0) {
            throw new EPPCodecException(this.getRootName() + ": unit should not be null");
        }
        this.extraValidate();
    }

    abstract void extraValidate() throws EPPCodecException;

    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryPeriodType)super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    static {
        VALID_UNITS.add(PERIOD_UNIT_DAY);
        VALID_UNITS.add(PERIOD_UNIT_HOUR);
        VALID_UNITS.add(PERIOD_UNIT_MONTH);
        VALID_UNITS.add(PERIOD_UNIT_YEAR);
    }
}

